/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Arrays;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.neo4j.internal.kernel.api.LabelSet;

public class Labels
implements LabelSet {
    private final long[] labels;

    private Labels(long[] labels) {
        this.labels = labels;
    }

    public static Labels from(long[] labels) {
        return new Labels(labels);
    }

    static Labels from(LongSet set) {
        return new Labels(set.toArray());
    }

    public int numberOfLabels() {
        return this.labels.length;
    }

    public int label(int offset) {
        return (int)this.labels[offset];
    }

    public boolean contains(int labelToken) {
        for (long label : this.labels) {
            assert ((long)((int)label) == label) : "value too big to be represented as and int";
            if (label != (long)labelToken) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "Labels" + Arrays.toString(this.labels);
    }

    public long[] all() {
        return this.labels;
    }
}

