/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.eclipse.collections.impl.iterator.ImmutableEmptyLongIterator;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.neo4j.internal.kernel.api.LabelSet;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipGroupCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.newapi.DefaultCursors;
import org.neo4j.kernel.impl.newapi.DefaultPropertyCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipGroupCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipTraversalCursor;
import org.neo4j.kernel.impl.newapi.HasChanges;
import org.neo4j.kernel.impl.newapi.Labels;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.storageengine.api.StorageNodeCursor;
import org.neo4j.storageengine.api.txstate.LongDiffSets;

class DefaultNodeCursor
implements NodeCursor {
    private Read read;
    private HasChanges hasChanges = HasChanges.MAYBE;
    private LongIterator addedNodes;
    private StorageNodeCursor storeCursor;
    private long single;
    private final DefaultCursors pool;

    DefaultNodeCursor(DefaultCursors pool, StorageNodeCursor storeCursor) {
        this.pool = pool;
        this.storeCursor = storeCursor;
    }

    void scan(Read read) {
        this.storeCursor.scan();
        this.read = read;
        this.single = -1L;
        this.hasChanges = HasChanges.MAYBE;
        this.addedNodes = ImmutableEmptyLongIterator.INSTANCE;
    }

    void single(long reference, Read read) {
        this.storeCursor.single(reference);
        this.read = read;
        this.single = reference;
        this.hasChanges = HasChanges.MAYBE;
        this.addedNodes = ImmutableEmptyLongIterator.INSTANCE;
    }

    public long nodeReference() {
        return this.storeCursor.entityReference();
    }

    public LabelSet labels() {
        if (this.hasChanges()) {
            TransactionState txState = this.read.txState();
            if (txState.nodeIsAddedInThisTx(this.storeCursor.entityReference())) {
                return Labels.from(txState.nodeStateLabelDiffSets(this.storeCursor.entityReference()).getAdded());
            }
            long[] longs = this.storeCursor.labels();
            LongHashSet labels = new LongHashSet();
            for (long labelToken : longs) {
                labels.add(labelToken);
            }
            return Labels.from((LongSet)txState.augmentLabels((MutableLongSet)labels, txState.getNodeState(this.storeCursor.entityReference())));
        }
        return Labels.from(this.storeCursor.labels());
    }

    public boolean hasLabel(int label) {
        if (this.hasChanges()) {
            TransactionState txState = this.read.txState();
            LongDiffSets diffSets = txState.nodeStateLabelDiffSets(this.storeCursor.entityReference());
            if (diffSets.getAdded().contains((long)label)) {
                return true;
            }
            if (diffSets.getRemoved().contains((long)label)) {
                return false;
            }
        }
        return this.storeCursor.hasLabel(label);
    }

    public void relationships(RelationshipGroupCursor cursor) {
        ((DefaultRelationshipGroupCursor)cursor).init(this.nodeReference(), this.relationshipGroupReference(), this.read);
    }

    public void allRelationships(RelationshipTraversalCursor cursor) {
        ((DefaultRelationshipTraversalCursor)cursor).init(this.nodeReference(), this.allRelationshipsReference(), this.read);
    }

    public void properties(PropertyCursor cursor) {
        ((DefaultPropertyCursor)cursor).initNode(this.nodeReference(), this.propertiesReference(), this.read, this.read);
    }

    public long relationshipGroupReference() {
        return this.storeCursor.relationshipGroupReference();
    }

    public long allRelationshipsReference() {
        return this.storeCursor.allRelationshipsReference();
    }

    public long propertiesReference() {
        return this.storeCursor.propertiesReference();
    }

    public boolean isDense() {
        return this.storeCursor.isDense();
    }

    public boolean next() {
        boolean hasChanges = this.hasChanges();
        if (hasChanges && this.addedNodes.hasNext()) {
            this.storeCursor.setCurrent(this.addedNodes.next());
            return true;
        }
        while (this.storeCursor.next()) {
            if (hasChanges && this.read.txState().nodeIsDeletedInThisTx(this.storeCursor.entityReference())) continue;
            return true;
        }
        return false;
    }

    public void close() {
        if (!this.isClosed()) {
            this.read = null;
            this.hasChanges = HasChanges.MAYBE;
            this.addedNodes = ImmutableEmptyLongIterator.INSTANCE;
            this.storeCursor.close();
            this.pool.accept(this);
        }
    }

    public boolean isClosed() {
        return this.read == null;
    }

    private boolean hasChanges() {
        switch (this.hasChanges) {
            case MAYBE: {
                boolean changes = this.read.hasTxStateWithChanges();
                if (changes) {
                    this.addedNodes = this.single != -1L ? (this.read.txState().nodeIsAddedInThisTx(this.single) ? LongSets.immutable.of(this.single).longIterator() : ImmutableEmptyLongIterator.INSTANCE) : this.read.txState().addedAndRemovedNodes().getAdded().freeze().longIterator();
                    this.hasChanges = HasChanges.YES;
                } else {
                    this.hasChanges = HasChanges.NO;
                }
                return changes;
            }
            case YES: {
                return true;
            }
            case NO: {
                return false;
            }
        }
        throw new IllegalStateException("Style guide, why are you making me do this");
    }

    public String toString() {
        if (this.isClosed()) {
            return "NodeCursor[closed state]";
        }
        return "NodeCursor[id=" + this.nodeReference() + ", " + this.storeCursor.toString() + "]";
    }

    void release() {
        this.storeCursor.release();
    }
}

