/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.config;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.neo4j.gis.spatial.index.Envelope;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettings;

enum SpatialIndexType {
    SingleSpaceFillingCurve(1){

        @Override
        public void writeHeader(SpaceFillingCurveSettings settings, PageCursor cursor) {
            cursor.putInt(settings.maxLevels);
            cursor.putInt(settings.dimensions);
            double[] min = settings.extents.getMin();
            double[] max = settings.extents.getMax();
            for (int i = 0; i < settings.dimensions; ++i) {
                cursor.putLong(Double.doubleToLongBits(min[i]));
                cursor.putLong(Double.doubleToLongBits(max[i]));
            }
        }

        @Override
        public void readHeader(SpaceFillingCurveSettings.SettingsFromIndexHeader settings, ByteBuffer headerBytes) {
            try {
                settings.maxLevels = headerBytes.getInt();
                settings.dimensions = headerBytes.getInt();
                double[] min = new double[settings.dimensions];
                double[] max = new double[settings.dimensions];
                for (int i = 0; i < settings.dimensions; ++i) {
                    min[i] = headerBytes.getDouble();
                    max[i] = headerBytes.getDouble();
                }
                settings.extents = new Envelope(min, max);
            }
            catch (BufferUnderflowException e) {
                settings.markAsFailed("Failed to read settings from GBPTree header: " + e.getMessage());
            }
        }
    };

    int id;

    public abstract void writeHeader(SpaceFillingCurveSettings var1, PageCursor var2);

    public abstract void readHeader(SpaceFillingCurveSettings.SettingsFromIndexHeader var1, ByteBuffer var2);

    private SpatialIndexType(int id) {
        this.id = id;
    }

    static SpatialIndexType get(int id) {
        for (SpatialIndexType type : SpatialIndexType.values()) {
            if (type.id != id) continue;
            return type;
        }
        return null;
    }
}

