/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.config;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.index.schema.config.EnvelopeSettings;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettings;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettingsFactory;
import org.neo4j.kernel.impl.index.schema.config.SpatialIndexSettings;
import org.neo4j.values.storable.CoordinateReferenceSystem;

public class ConfiguredSpaceFillingCurveSettingsCache {
    private final int maxBits;
    private final HashMap<CoordinateReferenceSystem, SpaceFillingCurveSettings> settings = new HashMap();

    public ConfiguredSpaceFillingCurveSettingsCache(Config config) {
        this.maxBits = config.get(SpatialIndexSettings.space_filling_curve_max_bits);
        HashMap<CoordinateReferenceSystem, EnvelopeSettings> env = EnvelopeSettings.envelopeSettingsFromConfig(config);
        for (Map.Entry<CoordinateReferenceSystem, EnvelopeSettings> entry : env.entrySet()) {
            CoordinateReferenceSystem crs = entry.getKey();
            this.settings.put(crs, SpaceFillingCurveSettingsFactory.fromConfig(this.maxBits, entry.getValue()));
        }
    }

    public SpaceFillingCurveSettings forCRS(CoordinateReferenceSystem crs) {
        if (this.settings.containsKey(crs)) {
            return this.settings.get(crs);
        }
        return SpaceFillingCurveSettingsFactory.fromConfig(this.maxBits, new EnvelopeSettings(crs));
    }
}

