/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.time.ZoneId;
import java.time.ZoneOffset;
import org.neo4j.kernel.impl.index.schema.NativeIndexSingleValueKey;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.TimeZones;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Values;

class ZonedDateTimeIndexKey
extends NativeIndexSingleValueKey<ZonedDateTimeIndexKey> {
    static final int SIZE = 24;
    long epochSecondUTC;
    int nanoOfSecond;
    short zoneId;
    int zoneOffsetSeconds;

    ZonedDateTimeIndexKey() {
    }

    @Override
    public Value asValue() {
        return TimeZones.validZoneId((short)this.zoneId) ? DateTimeValue.datetime((long)this.epochSecondUTC, (long)this.nanoOfSecond, (ZoneId)ZoneId.of(TimeZones.map((short)this.zoneId))) : DateTimeValue.datetime((long)this.epochSecondUTC, (long)this.nanoOfSecond, (ZoneOffset)ZoneOffset.ofTotalSeconds(this.zoneOffsetSeconds));
    }

    @Override
    public void initValueAsLowest(ValueGroup valueGroups) {
        this.epochSecondUTC = Long.MIN_VALUE;
        this.nanoOfSecond = Integer.MIN_VALUE;
        this.zoneId = Short.MIN_VALUE;
        this.zoneOffsetSeconds = Integer.MIN_VALUE;
    }

    @Override
    public void initValueAsHighest(ValueGroup valueGroups) {
        this.epochSecondUTC = Long.MAX_VALUE;
        this.nanoOfSecond = Integer.MAX_VALUE;
        this.zoneId = Short.MAX_VALUE;
        this.zoneOffsetSeconds = Integer.MAX_VALUE;
    }

    @Override
    public int compareValueTo(ZonedDateTimeIndexKey other) {
        int compare = Long.compare(this.epochSecondUTC, other.epochSecondUTC);
        if (compare == 0 && (compare = Integer.compare(this.nanoOfSecond, other.nanoOfSecond)) == 0 && TimeZones.validZoneOffset((int)this.zoneOffsetSeconds) && TimeZones.validZoneOffset((int)other.zoneOffsetSeconds) && (this.zoneOffsetSeconds != other.zoneOffsetSeconds || this.zoneId != other.zoneId)) {
            compare = Values.COMPARATOR.compare(this.asValue(), other.asValue());
        }
        return compare;
    }

    public String toString() {
        return String.format("value=%s,entityId=%d,epochSecond=%d,nanoOfSecond=%d,zoneId=%d,zoneOffset=%d", this.asValue(), this.getEntityId(), this.epochSecondUTC, this.nanoOfSecond, this.zoneId, this.zoneOffsetSeconds);
    }

    @Override
    public void writeDateTime(long epochSecondUTC, int nano, int offsetSeconds) {
        this.epochSecondUTC = epochSecondUTC;
        this.nanoOfSecond = nano;
        this.zoneOffsetSeconds = offsetSeconds;
        this.zoneId = (short)-1;
    }

    @Override
    public void writeDateTime(long epochSecondUTC, int nano, String zoneId) {
        this.epochSecondUTC = epochSecondUTC;
        this.nanoOfSecond = nano;
        this.zoneId = TimeZones.map((String)zoneId);
        this.zoneOffsetSeconds = 0;
    }

    @Override
    protected Value assertCorrectType(Value value) {
        if (!(value instanceof DateTimeValue)) {
            throw new IllegalArgumentException("Key layout does only support DateTimeValue, tried to create key from " + value);
        }
        return value;
    }
}

