/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.LabelSet;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.internal.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.explicitindex.AutoIndexingKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.internal.kernel.api.exceptions.schema.TooManyLabelsException;
import org.neo4j.internal.kernel.api.helpers.Nodes;
import org.neo4j.internal.kernel.api.helpers.RelationshipFactory;
import org.neo4j.internal.kernel.api.helpers.RelationshipSelections;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.SilentTokenNameLookup;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.core.EmbeddedProxySPI;
import org.neo4j.kernel.impl.core.RelationshipProxy;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class NodeProxy
implements Node,
RelationshipFactory<Relationship> {
    private final EmbeddedProxySPI spi;
    private final long nodeId;

    public NodeProxy(EmbeddedProxySPI spi, long nodeId) {
        this.nodeId = nodeId;
        this.spi = spi;
    }

    public long getId() {
        return this.nodeId;
    }

    public GraphDatabaseService getGraphDatabase() {
        return this.spi.getGraphDatabase();
    }

    public void delete() {
        KernelTransaction transaction = this.safeAcquireTransaction();
        try {
            boolean deleted = transaction.dataWrite().nodeDelete(this.getId());
            if (!deleted) {
                throw new NotFoundException("Unable to delete Node[" + this.nodeId + "] since it has already been deleted.");
            }
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
        catch (AutoIndexingKernelException e) {
            throw new IllegalStateException("Auto indexing encountered a failure while deleting the node: " + e.getMessage(), e);
        }
    }

    public ResourceIterable<Relationship> getRelationships() {
        return this.getRelationships(Direction.BOTH);
    }

    public ResourceIterable<Relationship> getRelationships(Direction direction) {
        KernelTransaction transaction = this.safeAcquireTransaction();
        return this.innerGetRelationships(transaction, direction, null);
    }

    public ResourceIterable<Relationship> getRelationships(RelationshipType ... types) {
        return this.getRelationships(Direction.BOTH, types);
    }

    public ResourceIterable<Relationship> getRelationships(RelationshipType type, Direction dir) {
        return this.getRelationships(dir, type);
    }

    public ResourceIterable<Relationship> getRelationships(Direction direction, RelationshipType ... types) {
        KernelTransaction transaction = this.safeAcquireTransaction();
        int[] typeIds = this.relTypeIds(types, transaction.tokenRead());
        return this.innerGetRelationships(transaction, direction, typeIds);
    }

    private ResourceIterable<Relationship> innerGetRelationships(KernelTransaction transaction, Direction direction, int[] typeIds) {
        return () -> this.getRelationshipSelectionIterator(transaction, direction, typeIds);
    }

    public boolean hasRelationship() {
        return this.hasRelationship(Direction.BOTH);
    }

    public boolean hasRelationship(Direction direction) {
        KernelTransaction transaction = this.safeAcquireTransaction();
        return this.innerHasRelationships(transaction, direction, null);
    }

    public boolean hasRelationship(RelationshipType ... types) {
        return this.hasRelationship(Direction.BOTH, types);
    }

    public boolean hasRelationship(Direction direction, RelationshipType ... types) {
        KernelTransaction transaction = this.safeAcquireTransaction();
        int[] typeIds = this.relTypeIds(types, transaction.tokenRead());
        return this.innerHasRelationships(transaction, direction, typeIds);
    }

    public boolean hasRelationship(RelationshipType type, Direction dir) {
        return this.hasRelationship(dir, type);
    }

    private boolean innerHasRelationships(KernelTransaction transaction, Direction direction, int[] typeIds) {
        try (ResourceIterator<Relationship> iterator = this.getRelationshipSelectionIterator(transaction, direction, typeIds);){
            boolean bl = iterator.hasNext();
            return bl;
        }
    }

    public Relationship getSingleRelationship(RelationshipType type, Direction dir) {
        try (ResourceIterator rels = this.getRelationships(dir, type).iterator();){
            if (!rels.hasNext()) {
                Relationship relationship = null;
                return relationship;
            }
            Relationship rel = (Relationship)rels.next();
            while (rels.hasNext()) {
                Relationship other = (Relationship)rels.next();
                if (other.equals(rel)) continue;
                throw new NotFoundException("More than one relationship[" + type + ", " + dir + "] found for " + this);
            }
            Relationship relationship = rel;
            return relationship;
        }
    }

    public void setProperty(String key, Object value) {
        int propertyKeyId;
        KernelTransaction transaction = this.spi.kernelTransaction();
        try {
            propertyKeyId = transaction.tokenWrite().propertyKeyGetOrCreateForName(key);
        }
        catch (IllegalTokenNameException e) {
            throw new IllegalArgumentException(String.format("Invalid property key '%s'.", key), e);
        }
        try (Statement ignore = transaction.acquireStatement();){
            transaction.dataWrite().nodeSetProperty(this.nodeId, propertyKeyId, Values.of((Object)value, (boolean)false));
        }
        catch (ConstraintValidationException e) {
            throw new ConstraintViolationException(e.getUserMessage((TokenNameLookup)new SilentTokenNameLookup(transaction.tokenRead())), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            this.spi.failTransaction();
            throw e;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException((Throwable)e);
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
        catch (AutoIndexingKernelException e) {
            throw new IllegalStateException("Auto indexing encountered a failure while setting property: " + e.getMessage(), e);
        }
        catch (KernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object removeProperty(String key) throws NotFoundException {
        KernelTransaction transaction = this.spi.kernelTransaction();
        try (Statement ignore = transaction.acquireStatement();){
            int propertyKeyId = transaction.tokenWrite().propertyKeyGetOrCreateForName(key);
            Object object = transaction.dataWrite().nodeRemoveProperty(this.nodeId, propertyKeyId).asObjectCopy();
            return object;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException((Throwable)e);
        }
        catch (IllegalTokenNameException e) {
            throw new IllegalArgumentException(String.format("Invalid property key '%s'.", key), e);
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
        catch (AutoIndexingKernelException e) {
            throw new IllegalStateException("Auto indexing encountered a failure while removing property: " + e.getMessage(), e);
        }
    }

    public Object getProperty(String key, Object defaultValue) {
        if (null == key) {
            throw new IllegalArgumentException("(null) property key is not allowed");
        }
        KernelTransaction transaction = this.safeAcquireTransaction();
        NodeCursor nodes = transaction.ambientNodeCursor();
        PropertyCursor properties = transaction.ambientPropertyCursor();
        int propertyKey = transaction.tokenRead().propertyKey(key);
        if (propertyKey == -1) {
            return defaultValue;
        }
        this.singleNode(transaction, nodes);
        nodes.properties(properties);
        while (properties.next()) {
            if (propertyKey != properties.propertyKey()) continue;
            Value value = properties.propertyValue();
            return value == Values.NO_VALUE ? defaultValue : value.asObjectCopy();
        }
        return defaultValue;
    }

    public Iterable<String> getPropertyKeys() {
        KernelTransaction transaction = this.safeAcquireTransaction();
        ArrayList<String> keys = new ArrayList<String>();
        try {
            NodeCursor nodes = transaction.ambientNodeCursor();
            PropertyCursor properties = transaction.ambientPropertyCursor();
            this.singleNode(transaction, nodes);
            TokenRead token = transaction.tokenRead();
            nodes.properties(properties);
            while (properties.next()) {
                keys.add(token.propertyKeyName(properties.propertyKey()));
            }
        }
        catch (PropertyKeyIdNotFoundKernelException e) {
            throw new IllegalStateException("Property key retrieved through kernel API should exist.", e);
        }
        return keys;
    }

    public Map<String, Object> getProperties(String ... keys) {
        Objects.requireNonNull(keys, "Properties keys should be not null array.");
        if (keys.length == 0) {
            return Collections.emptyMap();
        }
        KernelTransaction transaction = this.safeAcquireTransaction();
        int itemsToReturn = keys.length;
        HashMap<String, Object> properties = new HashMap<String, Object>(itemsToReturn);
        TokenRead token = transaction.tokenRead();
        int[] propertyIds = new int[itemsToReturn];
        for (int i = 0; i < itemsToReturn; ++i) {
            String key = keys[i];
            if (key == null) {
                throw new NullPointerException(String.format("Key %d was null", i));
            }
            propertyIds[i] = token.propertyKey(key);
        }
        NodeCursor nodes = transaction.ambientNodeCursor();
        PropertyCursor propertyCursor = transaction.ambientPropertyCursor();
        this.singleNode(transaction, nodes);
        nodes.properties(propertyCursor);
        int propertiesToFind = itemsToReturn;
        block1: while (propertiesToFind > 0 && propertyCursor.next()) {
            int currentKey = propertyCursor.propertyKey();
            for (int i = 0; i < itemsToReturn; ++i) {
                if (propertyIds[i] != currentKey) continue;
                properties.put(keys[i], propertyCursor.propertyValue().asObjectCopy());
                --propertiesToFind;
                continue block1;
            }
        }
        return properties;
    }

    public Map<String, Object> getAllProperties() {
        KernelTransaction transaction = this.safeAcquireTransaction();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        try {
            NodeCursor nodes = transaction.ambientNodeCursor();
            PropertyCursor propertyCursor = transaction.ambientPropertyCursor();
            TokenRead token = transaction.tokenRead();
            this.singleNode(transaction, nodes);
            nodes.properties(propertyCursor);
            while (propertyCursor.next()) {
                properties.put(token.propertyKeyName(propertyCursor.propertyKey()), propertyCursor.propertyValue().asObjectCopy());
            }
        }
        catch (PropertyKeyIdNotFoundKernelException e) {
            throw new IllegalStateException("Property key retrieved through kernel API should exist.", e);
        }
        return properties;
    }

    public Object getProperty(String key) throws NotFoundException {
        if (null == key) {
            throw new IllegalArgumentException("(null) property key is not allowed");
        }
        KernelTransaction transaction = this.safeAcquireTransaction();
        int propertyKey = transaction.tokenRead().propertyKey(key);
        if (propertyKey == -1) {
            throw new NotFoundException(String.format("No such property, '%s'.", key));
        }
        NodeCursor nodes = transaction.ambientNodeCursor();
        PropertyCursor properties = transaction.ambientPropertyCursor();
        this.singleNode(transaction, nodes);
        nodes.properties(properties);
        while (properties.next()) {
            if (propertyKey != properties.propertyKey()) continue;
            Value value = properties.propertyValue();
            if (value == Values.NO_VALUE) {
                throw new NotFoundException(String.format("No such property, '%s'.", key));
            }
            return value.asObjectCopy();
        }
        throw new NotFoundException(String.format("No such property, '%s'.", key));
    }

    public boolean hasProperty(String key) {
        if (null == key) {
            return false;
        }
        KernelTransaction transaction = this.safeAcquireTransaction();
        int propertyKey = transaction.tokenRead().propertyKey(key);
        if (propertyKey == -1) {
            return false;
        }
        NodeCursor nodes = transaction.ambientNodeCursor();
        PropertyCursor properties = transaction.ambientPropertyCursor();
        this.singleNode(transaction, nodes);
        nodes.properties(properties);
        while (properties.next()) {
            if (propertyKey != properties.propertyKey()) continue;
            return true;
        }
        return false;
    }

    private KernelTransaction safeAcquireTransaction() {
        KernelTransaction transaction = this.spi.kernelTransaction();
        if (transaction.isTerminated()) {
            Status terminationReason = (Status)transaction.getReasonIfTerminated().orElse(Status.Transaction.Terminated);
            throw new TransactionTerminatedException(terminationReason);
        }
        return transaction;
    }

    public int compareTo(Object node) {
        Node n = (Node)node;
        return Long.compare(this.getId(), n.getId());
    }

    public boolean equals(Object o) {
        return o instanceof Node && this.getId() == ((Node)o).getId();
    }

    public int hashCode() {
        return (int)(this.nodeId >>> 32 ^ this.nodeId);
    }

    public String toString() {
        return "Node[" + this.getId() + "]";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Relationship createRelationshipTo(Node otherNode, RelationshipType type) {
        if (otherNode == null) {
            throw new IllegalArgumentException("Other node is null.");
        }
        KernelTransaction transaction = this.safeAcquireTransaction();
        try (Statement ignore = transaction.acquireStatement();){
            int relationshipTypeId = transaction.tokenWrite().relationshipTypeGetOrCreateForName(type.name());
            long relationshipId = transaction.dataWrite().relationshipCreate(this.nodeId, relationshipTypeId, otherNode.getId());
            RelationshipProxy relationshipProxy = this.spi.newRelationshipProxy(relationshipId, this.nodeId, relationshipTypeId, otherNode.getId());
            return relationshipProxy;
        }
        catch (IllegalTokenNameException e) {
            throw new IllegalArgumentException(e);
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("Node[" + e.entityId() + "] is deleted and cannot be used to create a relationship");
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
    }

    public void addLabel(Label label) {
        KernelTransaction transaction = this.spi.kernelTransaction();
        try (Statement ignore = transaction.acquireStatement();){
            transaction.dataWrite().nodeAddLabel(this.getId(), transaction.tokenWrite().labelGetOrCreateForName(label.name()));
        }
        catch (ConstraintValidationException e) {
            throw new ConstraintViolationException(e.getUserMessage((TokenNameLookup)new SilentTokenNameLookup(transaction.tokenRead())), (Throwable)e);
        }
        catch (IllegalTokenNameException e) {
            throw new ConstraintViolationException(String.format("Invalid label name '%s'.", label.name()), (Throwable)e);
        }
        catch (TooManyLabelsException e) {
            throw new ConstraintViolationException("Unable to add label.", (Throwable)e);
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("No node with id " + this.getId() + " found.", (Throwable)e);
        }
        catch (KernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
    }

    public void removeLabel(Label label) {
        KernelTransaction transaction = this.spi.kernelTransaction();
        try (Statement ignore = transaction.acquireStatement();){
            int labelId = transaction.tokenRead().nodeLabel(label.name());
            if (labelId != -1) {
                transaction.dataWrite().nodeRemoveLabel(this.getId(), labelId);
            }
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("No node with id " + this.getId() + " found.", (Throwable)e);
        }
        catch (KernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean hasLabel(Label label) {
        KernelTransaction transaction = this.safeAcquireTransaction();
        NodeCursor nodes = transaction.ambientNodeCursor();
        try (Statement ignore = transaction.acquireStatement();){
            int labelId = transaction.tokenRead().nodeLabel(label.name());
            if (labelId == -1) {
                boolean bl = false;
                return bl;
            }
            transaction.dataRead().singleNode(this.nodeId, nodes);
            boolean bl = nodes.next() && nodes.hasLabel(labelId);
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Iterable<Label> getLabels() {
        KernelTransaction transaction = this.safeAcquireTransaction();
        NodeCursor nodes = transaction.ambientNodeCursor();
        try (Statement ignore = this.spi.statement();){
            this.singleNode(transaction, nodes);
            LabelSet labelSet = nodes.labels();
            TokenRead tokenRead = transaction.tokenRead();
            ArrayList<Label> list = new ArrayList<Label>(labelSet.numberOfLabels());
            for (int i = 0; i < labelSet.numberOfLabels(); ++i) {
                list.add(Label.label((String)tokenRead.nodeLabelName(labelSet.label(i))));
            }
            ArrayList<Label> arrayList = list;
            return arrayList;
        }
        catch (LabelNotFoundKernelException e) {
            throw new IllegalStateException("Label retrieved through kernel API should exist.", e);
        }
    }

    public int getDegree() {
        KernelTransaction transaction = this.safeAcquireTransaction();
        try (Statement ignore = transaction.acquireStatement();){
            NodeCursor nodes = transaction.ambientNodeCursor();
            this.singleNode(transaction, nodes);
            int n = Nodes.countAll((NodeCursor)nodes, (CursorFactory)transaction.cursors());
            return n;
        }
    }

    public int getDegree(RelationshipType type) {
        KernelTransaction transaction = this.safeAcquireTransaction();
        int typeId = transaction.tokenRead().relationshipType(type.name());
        if (typeId == -1) {
            return 0;
        }
        try (Statement ignore = transaction.acquireStatement();){
            NodeCursor nodes = transaction.ambientNodeCursor();
            this.singleNode(transaction, nodes);
            int n = Nodes.countAll((NodeCursor)nodes, (CursorFactory)transaction.cursors(), (int)typeId);
            return n;
        }
    }

    public int getDegree(Direction direction) {
        KernelTransaction transaction = this.safeAcquireTransaction();
        Throwable throwable = null;
        try (Statement ignore = transaction.acquireStatement();){
            NodeCursor nodes = transaction.ambientNodeCursor();
            this.singleNode(transaction, nodes);
            switch (direction) {
                case OUTGOING: {
                    int n = Nodes.countOutgoing((NodeCursor)nodes, (CursorFactory)transaction.cursors());
                    return n;
                }
                case INCOMING: {
                    int n = Nodes.countIncoming((NodeCursor)nodes, (CursorFactory)transaction.cursors());
                    return n;
                }
                case BOTH: {
                    int n = Nodes.countAll((NodeCursor)nodes, (CursorFactory)transaction.cursors());
                    return n;
                }
            }
            try {
                throw new IllegalStateException("Unknown direction " + direction);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public int getDegree(RelationshipType type, Direction direction) {
        KernelTransaction transaction = this.safeAcquireTransaction();
        int typeId = transaction.tokenRead().relationshipType(type.name());
        if (typeId == -1) {
            return 0;
        }
        Throwable throwable = null;
        try (Statement ignore = transaction.acquireStatement();){
            NodeCursor nodes = transaction.ambientNodeCursor();
            this.singleNode(transaction, nodes);
            switch (direction) {
                case OUTGOING: {
                    int n = Nodes.countOutgoing((NodeCursor)nodes, (CursorFactory)transaction.cursors(), (int)typeId);
                    return n;
                }
                case INCOMING: {
                    int n = Nodes.countIncoming((NodeCursor)nodes, (CursorFactory)transaction.cursors(), (int)typeId);
                    return n;
                }
                case BOTH: {
                    int n = Nodes.countAll((NodeCursor)nodes, (CursorFactory)transaction.cursors(), (int)typeId);
                    return n;
                }
            }
            try {
                throw new IllegalStateException("Unknown direction " + direction);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    /*
     * Exception decompiling
     */
    public Iterable<RelationshipType> getRelationshipTypes() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ResourceIterator<Relationship> getRelationshipSelectionIterator(KernelTransaction transaction, Direction direction, int[] typeIds) {
        NodeCursor node = transaction.ambientNodeCursor();
        transaction.dataRead().singleNode(this.getId(), node);
        if (!node.next()) {
            throw new NotFoundException(String.format("Node %d not found", this.nodeId));
        }
        switch (direction) {
            case OUTGOING: {
                return RelationshipSelections.outgoingIterator((CursorFactory)transaction.cursors(), (NodeCursor)node, (int[])typeIds, (RelationshipFactory)this);
            }
            case INCOMING: {
                return RelationshipSelections.incomingIterator((CursorFactory)transaction.cursors(), (NodeCursor)node, (int[])typeIds, (RelationshipFactory)this);
            }
            case BOTH: {
                return RelationshipSelections.allIterator((CursorFactory)transaction.cursors(), (NodeCursor)node, (int[])typeIds, (RelationshipFactory)this);
            }
        }
        throw new IllegalStateException("Unknown direction " + direction);
    }

    private int[] relTypeIds(RelationshipType[] types, TokenRead token) {
        int[] ids = new int[types.length];
        int outIndex = 0;
        for (RelationshipType type : types) {
            int id = token.relationshipType(type.name());
            if (id == -1) continue;
            ids[outIndex++] = id;
        }
        if (outIndex != ids.length) {
            ids = Arrays.copyOf(ids, outIndex);
        }
        return ids;
    }

    private void singleNode(KernelTransaction transaction, NodeCursor nodes) {
        transaction.dataRead().singleNode(this.nodeId, nodes);
        if (!nodes.next()) {
            throw new NotFoundException((Throwable)new EntityNotFoundException(EntityType.NODE, this.nodeId));
        }
    }

    public Relationship relationship(long id, long startNodeId, int typeId, long endNodeId) {
        return this.spi.newRelationshipProxy(id, startNodeId, typeId, endNodeId);
    }
}

