/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.updater.SwallowingIndexUpdater;
import org.neo4j.storageengine.api.schema.CapableIndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.PopulationProgress;

public abstract class AbstractSwallowingIndexProxy
implements IndexProxy {
    private final CapableIndexDescriptor capableIndexDescriptor;
    private final IndexPopulationFailure populationFailure;

    AbstractSwallowingIndexProxy(CapableIndexDescriptor capableIndexDescriptor, IndexPopulationFailure populationFailure) {
        this.capableIndexDescriptor = capableIndexDescriptor;
        this.populationFailure = populationFailure;
    }

    @Override
    public IndexPopulationFailure getPopulationFailure() {
        return this.populationFailure;
    }

    @Override
    public PopulationProgress getIndexPopulationProgress() {
        return PopulationProgress.NONE;
    }

    @Override
    public void start() {
        String message = "Unable to start index, it is in a " + this.getState().name() + " state.";
        throw new UnsupportedOperationException(message + ", caused by: " + this.getPopulationFailure());
    }

    @Override
    public IndexUpdater newUpdater(IndexUpdateMode mode) {
        return SwallowingIndexUpdater.INSTANCE;
    }

    @Override
    public void force(IOLimiter ioLimiter) {
    }

    @Override
    public void refresh() {
    }

    @Override
    public CapableIndexDescriptor getDescriptor() {
        return this.capableIndexDescriptor;
    }

    @Override
    public void close() {
    }

    @Override
    public IndexReader newReader() {
        throw new UnsupportedOperationException();
    }
}

