/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.concurrent.TimeUnit;
import org.neo4j.kernel.impl.api.KernelTransactionTimeoutMonitor;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobScheduler;

public class KernelTransactionMonitorScheduler
extends LifecycleAdapter {
    private final KernelTransactionTimeoutMonitor kernelTransactionTimeoutMonitor;
    private final JobScheduler scheduler;
    private final long checkIntervalMillis;
    private JobHandle monitorJobHandle;

    public KernelTransactionMonitorScheduler(KernelTransactionTimeoutMonitor kernelTransactionTimeoutMonitor, JobScheduler scheduler, long checkIntervalMillis) {
        this.kernelTransactionTimeoutMonitor = kernelTransactionTimeoutMonitor;
        this.scheduler = scheduler;
        this.checkIntervalMillis = checkIntervalMillis;
    }

    public void start() {
        if (this.checkIntervalMillis > 0L) {
            this.monitorJobHandle = this.scheduler.scheduleRecurring(Group.TRANSACTION_TIMEOUT_MONITOR, (Runnable)this.kernelTransactionTimeoutMonitor, this.checkIntervalMillis, TimeUnit.MILLISECONDS);
        }
    }

    public void stop() {
        if (this.monitorJobHandle != null) {
            this.monitorJobHandle.cancel(true);
        }
    }
}

