/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.neo4j.kernel.configuration.ConfigurationMigrator;
import org.neo4j.logging.Log;

public class BaseConfigurationMigrator
implements ConfigurationMigrator {
    private final List<Migration> migrations = new ArrayList<Migration>();

    public void add(Migration migration) {
        this.migrations.add(migration);
    }

    @Override
    @Nonnull
    public Map<String, String> apply(@Nonnull Map<String, String> rawConfiguration, @Nonnull Log log) {
        boolean printedDeprecationMessage = false;
        for (Migration migration : this.migrations) {
            if (!migration.appliesTo(rawConfiguration)) continue;
            if (!printedDeprecationMessage) {
                printedDeprecationMessage = true;
                log.warn("WARNING! Deprecated configuration options used. See manual for details");
            }
            rawConfiguration = migration.apply(rawConfiguration);
            log.warn(migration.getDeprecationMessage());
        }
        return rawConfiguration;
    }

    public static abstract class SpecificPropertyMigration
    implements Migration {
        private final String propertyKey;
        private final String deprecationMessage;

        SpecificPropertyMigration(String propertyKey, String deprecationMessage) {
            this.propertyKey = propertyKey;
            this.deprecationMessage = deprecationMessage;
        }

        @Override
        public boolean appliesTo(Map<String, String> rawConfiguration) {
            return rawConfiguration.containsKey(this.propertyKey);
        }

        @Override
        public Map<String, String> apply(Map<String, String> rawConfiguration) {
            String value = rawConfiguration.remove(this.propertyKey);
            this.setValueWithOldSetting(value, rawConfiguration);
            return rawConfiguration;
        }

        @Override
        public String getDeprecationMessage() {
            return this.deprecationMessage;
        }

        public abstract void setValueWithOldSetting(String var1, Map<String, String> var2);
    }

    public static interface Migration {
        public boolean appliesTo(Map<String, String> var1);

        public Map<String, String> apply(Map<String, String> var1);

        public String getDeprecationMessage();
    }
}

