/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.labelscan;

import org.eclipse.collections.api.list.primitive.LongList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.neo4j.collection.PrimitiveLongCollections;

public class NodeLabelRange {
    private final long idRange;
    private final long[] nodes;
    private final long[][] labels;

    public NodeLabelRange(long idRange, long[][] labels) {
        this.idRange = idRange;
        this.labels = labels;
        int rangeSize = labels.length;
        long baseNodeId = idRange * (long)rangeSize;
        this.nodes = new long[rangeSize];
        for (int i = 0; i < rangeSize; ++i) {
            this.nodes[i] = baseNodeId + (long)i;
        }
    }

    public long id() {
        return this.idRange;
    }

    public long[] nodes() {
        return this.nodes;
    }

    public long[] labels(long nodeId) {
        long firstNodeId = this.idRange * (long)this.labels.length;
        int index = Math.toIntExact(nodeId - firstNodeId);
        assert (index >= 0 && index < this.labels.length) : "nodeId:" + nodeId + ", idRange:" + this.idRange;
        return this.labels[index] != null ? this.labels[index] : PrimitiveLongCollections.EMPTY_LONG_ARRAY;
    }

    private static String toString(String prefix, long[] nodes, long[][] labels) {
        StringBuilder result = new StringBuilder(prefix);
        result.append("; {");
        for (int i = 0; i < nodes.length; ++i) {
            if (i != 0) {
                result.append(", ");
            }
            result.append("Node[").append(nodes[i]).append("]: Labels[");
            String sep = "";
            if (labels[i] != null) {
                for (long labelId : labels[i]) {
                    result.append(sep).append(labelId);
                    sep = ", ";
                }
            } else {
                result.append("null");
            }
            result.append(']');
        }
        return result.append("}]").toString();
    }

    public String toString() {
        String rangeString = this.idRange * (long)this.labels.length + "-" + (this.idRange + 1L) * (long)this.labels.length;
        String prefix = "NodeLabelRange[idRange=" + rangeString;
        return NodeLabelRange.toString(prefix, this.nodes, this.labels);
    }

    public static void readBitmap(long bitmap, long labelId, MutableLongList[] labelsPerNode) {
        while (bitmap != 0L) {
            int relativeNodeId = Long.numberOfTrailingZeros(bitmap);
            if (labelsPerNode[relativeNodeId] == null) {
                labelsPerNode[relativeNodeId] = new LongArrayList();
            }
            labelsPerNode[relativeNodeId].add(labelId);
            bitmap &= bitmap - 1L;
        }
    }

    public static long[][] convertState(LongList[] state) {
        long[][] labelIdsByNodeIndex = new long[state.length][];
        for (int i = 0; i < state.length; ++i) {
            LongList labelIdList = state[i];
            if (labelIdList == null) continue;
            labelIdsByNodeIndex[i] = labelIdList.toArray();
        }
        return labelIdsByNodeIndex;
    }
}

