/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.net.BindException;
import org.neo4j.helpers.ListenSocketAddress;

public class PortBindException
extends BindException {
    public PortBindException(ListenSocketAddress address, Throwable original) {
        this(address, null, original);
    }

    public PortBindException(ListenSocketAddress address1, ListenSocketAddress address2, Throwable original) {
        super(PortBindException.createMessage(address1, address2));
        this.setStackTrace(original.getStackTrace());
    }

    private static String createMessage(ListenSocketAddress address1, ListenSocketAddress address2) {
        if (address1 == null && address2 == null) {
            return "Address is already in use, cannot bind to it.";
        }
        if (address1 != null && address2 != null) {
            return String.format("At least one of the addresses %s or %s is already in use, cannot bind to it.", address1, address2);
        }
        return String.format("Address %s is already in use, cannot bind to it.", address1 != null ? address1 : address2);
    }
}

