/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.kernel.impl.transaction.TransactionCounters;
import org.neo4j.kernel.impl.transaction.TransactionMonitor;

public class TransactionStats
implements TransactionMonitor,
TransactionCounters {
    private final AtomicLong startedTransactionCount = new AtomicLong();
    private final AtomicLong activeReadTransactionCount = new AtomicLong();
    private final AtomicLong activeWriteTransactionCount = new AtomicLong();
    private final AtomicLong committedReadTransactionCount = new AtomicLong();
    private final AtomicLong committedWriteTransactionCount = new AtomicLong();
    private final AtomicLong rolledBackReadTransactionCount = new AtomicLong();
    private final AtomicLong rolledBackWriteTransactionCount = new AtomicLong();
    private final AtomicLong terminatedReadTransactionCount = new AtomicLong();
    private final AtomicLong terminatedWriteTransactionCount = new AtomicLong();
    private volatile long peakTransactionCount;

    @Override
    public void transactionStarted() {
        this.startedTransactionCount.incrementAndGet();
        long active = this.activeReadTransactionCount.incrementAndGet();
        this.peakTransactionCount = Math.max(this.peakTransactionCount, active);
    }

    @Override
    public void transactionFinished(boolean committed, boolean write) {
        this.decrementCounter(this.activeReadTransactionCount, this.activeWriteTransactionCount, write);
        if (committed) {
            this.incrementCounter(this.committedReadTransactionCount, this.committedWriteTransactionCount, write);
        } else {
            this.incrementCounter(this.rolledBackReadTransactionCount, this.rolledBackWriteTransactionCount, write);
        }
    }

    @Override
    public void transactionTerminated(boolean write) {
        this.incrementCounter(this.terminatedReadTransactionCount, this.terminatedWriteTransactionCount, write);
    }

    @Override
    public void upgradeToWriteTransaction() {
        long readCount = this.activeReadTransactionCount.decrementAndGet();
        assert (readCount >= 0L);
        long writeCount = this.activeWriteTransactionCount.incrementAndGet();
        assert (writeCount > 0L);
    }

    @Override
    public long getPeakConcurrentNumberOfTransactions() {
        return this.peakTransactionCount;
    }

    @Override
    public long getNumberOfStartedTransactions() {
        return this.startedTransactionCount.get();
    }

    @Override
    public long getNumberOfCommittedTransactions() {
        return this.getNumberOfCommittedReadTransactions() + this.getNumberOfCommittedWriteTransactions();
    }

    @Override
    public long getNumberOfCommittedReadTransactions() {
        return this.committedReadTransactionCount.get();
    }

    @Override
    public long getNumberOfCommittedWriteTransactions() {
        return this.committedWriteTransactionCount.get();
    }

    @Override
    public long getNumberOfActiveTransactions() {
        return this.getNumberOfActiveReadTransactions() + this.getNumberOfActiveWriteTransactions();
    }

    @Override
    public long getNumberOfActiveReadTransactions() {
        return this.activeReadTransactionCount.get();
    }

    @Override
    public long getNumberOfActiveWriteTransactions() {
        return this.activeWriteTransactionCount.get();
    }

    @Override
    public long getNumberOfTerminatedTransactions() {
        return this.getNumberOfTerminatedReadTransactions() + this.getNumberOfTerminatedWriteTransactions();
    }

    @Override
    public long getNumberOfTerminatedReadTransactions() {
        return this.terminatedReadTransactionCount.get();
    }

    @Override
    public long getNumberOfTerminatedWriteTransactions() {
        return this.terminatedWriteTransactionCount.get();
    }

    @Override
    public long getNumberOfRolledBackTransactions() {
        return this.getNumberOfRolledBackReadTransactions() + this.getNumberOfRolledBackWriteTransactions();
    }

    @Override
    public long getNumberOfRolledBackReadTransactions() {
        return this.rolledBackReadTransactionCount.get();
    }

    @Override
    public long getNumberOfRolledBackWriteTransactions() {
        return this.rolledBackWriteTransactionCount.get();
    }

    private void incrementCounter(AtomicLong readCount, AtomicLong writeCount, boolean write) {
        long count;
        long l = count = write ? writeCount.incrementAndGet() : readCount.incrementAndGet();
        assert (count > 0L);
    }

    private void decrementCounter(AtomicLong readCount, AtomicLong writeCount, boolean write) {
        long count;
        long l = count = write ? writeCount.decrementAndGet() : readCount.decrementAndGet();
        assert (count >= 0L);
    }
}

