/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.graphdb.Direction;
import org.neo4j.kernel.api.LegacyIndexHits;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.RelationshipTypeIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotApplicableKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.legacyindex.LegacyIndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.IndexBrokenKernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.proc.ProcedureSignature;
import org.neo4j.kernel.api.proc.QualifiedName;
import org.neo4j.kernel.api.proc.UserFunctionSignature;
import org.neo4j.kernel.api.schema.IndexQuery;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.api.schema.constaints.ConstraintDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.store.RelationshipIterator;
import org.neo4j.register.Register;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.PropertyItem;
import org.neo4j.storageengine.api.RelationshipItem;
import org.neo4j.storageengine.api.Token;
import org.neo4j.storageengine.api.lock.ResourceType;
import org.neo4j.storageengine.api.schema.PopulationProgress;

public interface ReadOperations {
    public static final int ANY_LABEL = -1;
    public static final int ANY_RELATIONSHIP_TYPE = -1;
    public static final int NO_SUCH_LABEL = -1;
    public static final int NO_SUCH_PROPERTY_KEY = -1;

    public int labelGetForName(String var1);

    public String labelGetName(int var1) throws LabelNotFoundKernelException;

    public Iterator<Token> labelsGetAllTokens();

    public int propertyKeyGetForName(String var1);

    public String propertyKeyGetName(int var1) throws PropertyKeyIdNotFoundKernelException;

    public Iterator<Token> propertyKeyGetAllTokens();

    public int relationshipTypeGetForName(String var1);

    public String relationshipTypeGetName(int var1) throws RelationshipTypeIdNotFoundKernelException;

    public Iterator<Token> relationshipTypesGetAllTokens();

    public int labelCount();

    public int propertyKeyCount();

    public int relationshipTypeCount();

    public PrimitiveLongIterator nodesGetForLabel(int var1);

    public PrimitiveLongIterator indexQuery(IndexDescriptor var1, IndexQuery ... var2) throws IndexNotFoundKernelException, IndexNotApplicableKernelException;

    public PrimitiveLongIterator nodesGetAll();

    public PrimitiveLongIterator relationshipsGetAll();

    public RelationshipIterator nodeGetRelationships(long var1, Direction var3, int[] var4) throws EntityNotFoundException;

    public RelationshipIterator nodeGetRelationships(long var1, Direction var3) throws EntityNotFoundException;

    public long nodeGetFromUniqueIndexSeek(IndexDescriptor var1, IndexQuery.ExactPredicate ... var2) throws IndexNotFoundKernelException, IndexBrokenKernelException, IndexNotApplicableKernelException;

    public long nodesCountIndexed(IndexDescriptor var1, long var2, Object var4) throws IndexNotFoundKernelException, IndexBrokenKernelException;

    public boolean nodeExists(long var1);

    public boolean nodeHasLabel(long var1, int var3) throws EntityNotFoundException;

    public int nodeGetDegree(long var1, Direction var3, int var4) throws EntityNotFoundException;

    public int nodeGetDegree(long var1, Direction var3) throws EntityNotFoundException;

    public boolean nodeIsDense(long var1) throws EntityNotFoundException;

    public PrimitiveIntIterator nodeGetLabels(long var1) throws EntityNotFoundException;

    public PrimitiveIntIterator nodeGetPropertyKeys(long var1) throws EntityNotFoundException;

    public PrimitiveIntIterator relationshipGetPropertyKeys(long var1) throws EntityNotFoundException;

    public PrimitiveIntIterator graphGetPropertyKeys();

    public PrimitiveIntIterator nodeGetRelationshipTypes(long var1) throws EntityNotFoundException;

    public boolean nodeHasProperty(long var1, int var3) throws EntityNotFoundException;

    public Object nodeGetProperty(long var1, int var3) throws EntityNotFoundException;

    public boolean relationshipHasProperty(long var1, int var3) throws EntityNotFoundException;

    public Object relationshipGetProperty(long var1, int var3) throws EntityNotFoundException;

    public boolean graphHasProperty(int var1);

    public Object graphGetProperty(int var1);

    public <EXCEPTION extends Exception> void relationshipVisit(long var1, RelationshipVisitor<EXCEPTION> var3) throws EntityNotFoundException, EXCEPTION;

    public long nodesGetCount();

    public long relationshipsGetCount();

    public Cursor<NodeItem> nodeCursorById(long var1) throws EntityNotFoundException;

    public Cursor<RelationshipItem> relationshipCursorById(long var1) throws EntityNotFoundException;

    public Cursor<PropertyItem> nodeGetProperties(NodeItem var1);

    public Cursor<PropertyItem> relationshipGetProperties(RelationshipItem var1);

    public IndexDescriptor indexGetForSchema(LabelSchemaDescriptor var1) throws SchemaRuleNotFoundException;

    public Iterator<IndexDescriptor> indexesGetForLabel(int var1);

    public Iterator<IndexDescriptor> indexesGetAll();

    public InternalIndexState indexGetState(IndexDescriptor var1) throws IndexNotFoundKernelException;

    public PopulationProgress indexGetPopulationProgress(IndexDescriptor var1) throws IndexNotFoundKernelException;

    public long indexSize(IndexDescriptor var1) throws IndexNotFoundKernelException;

    public double indexUniqueValuesSelectivity(IndexDescriptor var1) throws IndexNotFoundKernelException;

    public String indexGetFailure(IndexDescriptor var1) throws IndexNotFoundKernelException;

    public Iterator<ConstraintDescriptor> constraintsGetForSchema(SchemaDescriptor var1);

    public Iterator<ConstraintDescriptor> constraintsGetForLabel(int var1);

    public Iterator<ConstraintDescriptor> constraintsGetForRelationshipType(int var1);

    public Iterator<ConstraintDescriptor> constraintsGetAll();

    public Long indexGetOwningUniquenessConstraintId(IndexDescriptor var1);

    public <K, V> V schemaStateGetOrCreate(K var1, Function<K, V> var2);

    public void schemaStateFlush();

    public void acquireExclusive(ResourceType var1, long var2);

    public void acquireShared(ResourceType var1, long var2);

    public void releaseExclusive(ResourceType var1, long var2);

    public void releaseShared(ResourceType var1, long var2);

    public boolean nodeLegacyIndexExists(String var1, Map<String, String> var2);

    public boolean relationshipLegacyIndexExists(String var1, Map<String, String> var2);

    public Map<String, String> nodeLegacyIndexGetConfiguration(String var1) throws LegacyIndexNotFoundKernelException;

    public Map<String, String> relationshipLegacyIndexGetConfiguration(String var1) throws LegacyIndexNotFoundKernelException;

    public LegacyIndexHits nodeLegacyIndexGet(String var1, String var2, Object var3) throws LegacyIndexNotFoundKernelException;

    public LegacyIndexHits nodeLegacyIndexQuery(String var1, String var2, Object var3) throws LegacyIndexNotFoundKernelException;

    public LegacyIndexHits nodeLegacyIndexQuery(String var1, Object var2) throws LegacyIndexNotFoundKernelException;

    public LegacyIndexHits relationshipLegacyIndexGet(String var1, String var2, Object var3, long var4, long var6) throws LegacyIndexNotFoundKernelException;

    public LegacyIndexHits relationshipLegacyIndexQuery(String var1, String var2, Object var3, long var4, long var6) throws LegacyIndexNotFoundKernelException;

    public LegacyIndexHits relationshipLegacyIndexQuery(String var1, Object var2, long var3, long var5) throws LegacyIndexNotFoundKernelException;

    public String[] nodeLegacyIndexesGetAll();

    public String[] relationshipLegacyIndexesGetAll();

    public long countsForNode(int var1);

    public long countsForNodeWithoutTxState(int var1);

    public long countsForRelationship(int var1, int var2, int var3);

    public long countsForRelationshipWithoutTxState(int var1, int var2, int var3);

    public Register.DoubleLongRegister indexUpdatesAndSize(IndexDescriptor var1, Register.DoubleLongRegister var2) throws IndexNotFoundKernelException;

    public Register.DoubleLongRegister indexSample(IndexDescriptor var1, Register.DoubleLongRegister var2) throws IndexNotFoundKernelException;

    public ProcedureSignature procedureGet(QualifiedName var1) throws ProcedureException;

    public Optional<UserFunctionSignature> functionGet(QualifiedName var1);

    public Optional<UserFunctionSignature> aggregationFunctionGet(QualifiedName var1);

    public Set<UserFunctionSignature> functionsGetAll();

    public Set<ProcedureSignature> proceduresGetAll();
}

