/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.kvstore;

import java.time.Clock;

public class RotationTimerFactory {
    private Clock clock;
    private long timeoutMillis;

    public RotationTimerFactory(Clock clock, long timeoutMillis) {
        this.clock = clock;
        this.timeoutMillis = timeoutMillis;
    }

    public RotationTimer createTimer() {
        long startTime = this.clock.millis();
        return new RotationTimer(startTime, startTime + this.timeoutMillis);
    }

    class RotationTimer {
        private long startTime;
        private long timeoutTime;

        public RotationTimer(long startTime, long timeoutTime) {
            this.startTime = startTime;
            this.timeoutTime = timeoutTime;
        }

        public boolean isTimedOut() {
            return RotationTimerFactory.this.clock.millis() > this.timeoutTime;
        }

        public long getElapsedTimeMillis() {
            return RotationTimerFactory.this.clock.millis() - this.startTime;
        }
    }
}

