/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.io.IOException;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.api.TransactionApplier;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.storageengine.api.TransactionApplicationMode;

public class CountsStoreTransactionApplier
extends TransactionApplier.Adapter {
    private final TransactionApplicationMode mode;
    private final CountsAccessor.Updater countsUpdater;

    public CountsStoreTransactionApplier(TransactionApplicationMode mode, CountsAccessor.Updater countsUpdater) {
        this.mode = mode;
        this.countsUpdater = countsUpdater;
    }

    @Override
    public void close() throws Exception {
        assert (this.countsUpdater != null || this.mode == TransactionApplicationMode.RECOVERY) : "You must call begin first";
        if (this.countsUpdater != null) {
            this.countsUpdater.close();
        }
    }

    @Override
    public boolean visitNodeCountsCommand(Command.NodeCountsCommand command) {
        assert (this.countsUpdater != null || this.mode == TransactionApplicationMode.RECOVERY) : "You must call begin first";
        if (this.countsUpdater != null) {
            this.countsUpdater.incrementNodeCount(command.labelId(), command.delta());
        }
        return false;
    }

    @Override
    public boolean visitRelationshipCountsCommand(Command.RelationshipCountsCommand command) throws IOException {
        assert (this.countsUpdater != null || this.mode == TransactionApplicationMode.RECOVERY) : "You must call begin first";
        if (this.countsUpdater != null) {
            this.countsUpdater.incrementRelationshipCount(command.startLabelId(), command.typeId(), command.endLabelId(), command.delta());
        }
        return false;
    }
}

