/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.exceptions.schema.ConstraintViolationKernelException;

public class RelationshipPropertyExistenceConstraintViolationKernelException
extends ConstraintViolationKernelException {
    private final int relationshipTypeId;
    private final int propertyKeyId;
    private final long relationshipId;

    public RelationshipPropertyExistenceConstraintViolationKernelException(int relationshipTypeId, int propertyKeyId, long relationshipId) {
        super("Relationship %d with type %d must have the property %d", relationshipId, relationshipTypeId, propertyKeyId);
        this.relationshipTypeId = relationshipTypeId;
        this.propertyKeyId = propertyKeyId;
        this.relationshipId = relationshipId;
    }

    @Override
    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        return String.format("Relationship %d with type \"%s\" must have the property \"%s\" due to a constraint", this.relationshipId, tokenNameLookup.relationshipTypeGetName(this.relationshipTypeId), tokenNameLookup.propertyKeyGetName(this.propertyKeyId));
    }

    public int relationshipTypeId() {
        return this.relationshipTypeId;
    }

    public int propertyKeyId() {
        return this.propertyKeyId;
    }
}

