/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import java.util.Iterator;
import org.neo4j.function.Factory;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.traversal.TraversalMetadata;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.internal.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.impl.traversal.TraverserIterator;

public class DefaultTraverser
implements Traverser {
    private final Factory<TraverserIterator> traverserIteratorFactory;
    private TraversalMetadata lastIterator;

    DefaultTraverser(Factory<TraverserIterator> traverserIteratorFactory) {
        this.traverserIteratorFactory = traverserIteratorFactory;
    }

    public Iterable<Node> nodes() {
        return new PathIterableWrapper<Node>(this, (Iterable)((Object)this)){

            @Override
            protected Node convert(Path path) {
                return path.endNode();
            }
        };
    }

    public Iterable<Relationship> relationships() {
        return new PathIterableWrapper<Relationship>(this, (Iterable)((Object)this)){

            @Override
            public Iterator<Relationship> iterator() {
                final Iterator<Path> pathIterator = this.pathIterator();
                return new PrefetchingIterator<Relationship>(this){

                    protected Relationship fetchNextOrNull() {
                        while (pathIterator.hasNext()) {
                            Path path = (Path)pathIterator.next();
                            if (path.length() <= 0) continue;
                            return path.lastRelationship();
                        }
                        return null;
                    }
                };
            }

            @Override
            protected Relationship convert(Path path) {
                return path.lastRelationship();
            }
        };
    }

    public Iterator<Path> iterator() {
        TraverserIterator traverserIterator = (TraverserIterator)this.traverserIteratorFactory.newInstance();
        this.lastIterator = traverserIterator;
        return traverserIterator;
    }

    public TraversalMetadata metadata() {
        return this.lastIterator;
    }

    private static abstract class PathIterableWrapper<T>
    implements Iterable<T> {
        private final Iterable<Path> iterableToWrap;

        PathIterableWrapper(Iterable<Path> iterableToWrap) {
            this.iterableToWrap = iterableToWrap;
        }

        Iterator<Path> pathIterator() {
            return this.iterableToWrap.iterator();
        }

        @Override
        public Iterator<T> iterator() {
            final Iterator<Path> iterator = this.pathIterator();
            return new PrefetchingIterator<T>(){

                protected T fetchNextOrNull() {
                    return iterator.hasNext() ? (Object)this.convert((Path)iterator.next()) : null;
                }
            };
        }

        protected abstract T convert(Path var1);
    }
}

