/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.index.internal.gbptree.Header;
import org.neo4j.index.internal.gbptree.MultiRootGBPTree;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.index.schema.NativeIndexHeaderReader;

public final class NativeIndexes {
    private NativeIndexes() {
    }

    public static InternalIndexState readState(PageCache pageCache, Path indexFile, String databaseName, CursorContext cursorContext, ImmutableSet<OpenOption> openOptions) throws IOException {
        NativeIndexHeaderReader headerReader = new NativeIndexHeaderReader();
        MultiRootGBPTree.readHeader((PageCache)pageCache, (Path)indexFile, (Header.Reader)headerReader, (String)databaseName, (CursorContext)cursorContext, openOptions);
        return switch (headerReader.state) {
            case 0 -> InternalIndexState.FAILED;
            case 1 -> InternalIndexState.ONLINE;
            case 2 -> InternalIndexState.POPULATING;
            default -> throw new IllegalStateException("Unexpected initial state byte value " + headerReader.state);
        };
    }

    static String readFailureMessage(PageCache pageCache, Path indexFile, String databaseName, CursorContext cursorContext, ImmutableSet<OpenOption> openOptions) throws IOException {
        NativeIndexHeaderReader headerReader = new NativeIndexHeaderReader();
        MultiRootGBPTree.readHeader((PageCache)pageCache, (Path)indexFile, (Header.Reader)headerReader, (String)databaseName, (CursorContext)cursorContext, openOptions);
        return headerReader.failureMessage;
    }
}

