/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.Closeable;
import java.io.IOException;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.BlockEntry;
import org.neo4j.kernel.impl.index.schema.NullValue;

public class IndexUpdateCursor<KEY>
implements Closeable {
    private final PageCursor cursor;
    private final Layout<KEY, NullValue> layout;
    private boolean addition;
    private long version;
    private final KEY key;

    IndexUpdateCursor(PageCursor cursor, Layout<KEY, NullValue> layout) {
        this.cursor = cursor;
        this.layout = layout;
        this.key = layout.newKey();
    }

    public boolean next() throws IOException {
        byte updateModeType = this.cursor.getByte();
        if (updateModeType == -1) {
            return false;
        }
        this.addition = updateModeType == 1;
        this.version = this.cursor.getLong();
        BlockEntry.read(this.cursor, this.layout, this.key);
        return true;
    }

    public KEY key() {
        return this.key;
    }

    public boolean addition() {
        return this.addition;
    }

    public long version() {
        return this.version;
    }

    @Override
    public void close() throws IOException {
        this.cursor.close();
    }
}

