/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.function.BooleanSupplier;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.io.pagecache.OutOfDiskSpaceException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.api.CommandCommitListeners;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.transaction.log.LogAppendEvent;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.tracing.StoreApplyEvent;
import org.neo4j.kernel.impl.transaction.tracing.TransactionWriteEvent;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageEngineTransaction;
import org.neo4j.storageengine.api.TransactionApplicationMode;

public class InternalTransactionCommitProcess
implements TransactionCommitProcess {
    private final TransactionAppender appender;
    private final StorageEngine storageEngine;
    private final boolean preAllocateSpaceInStores;
    private final CommandCommitListeners commandCommitListeners;
    private final BooleanSupplier prefetchCommands;
    private final Log log;

    public InternalTransactionCommitProcess(TransactionAppender appender, StorageEngine storageEngine, boolean preAllocateSpaceInStores, CommandCommitListeners commandCommitListeners, BooleanSupplier prefetchCommands, LogProvider logProvider) {
        this.appender = appender;
        this.storageEngine = storageEngine;
        this.preAllocateSpaceInStores = preAllocateSpaceInStores;
        this.commandCommitListeners = commandCommitListeners;
        this.prefetchCommands = prefetchCommands;
        this.log = logProvider.getLog(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long commit(StorageEngineTransaction batch, TransactionWriteEvent transactionWriteEvent, TransactionApplicationMode mode) throws TransactionFailureException {
        try {
            if (this.preAllocateSpaceInStores) {
                this.preAllocateSpaceInStores(batch, mode);
            }
            if (this.prefetchCommands.getAsBoolean()) {
                this.storageEngine.prefetchPagesForCommands(batch, mode);
            }
            long lastAppendIndex = this.appendToLog(batch, transactionWriteEvent);
            try {
                this.applyToStore(batch, transactionWriteEvent, mode);
            }
            finally {
                InternalTransactionCommitProcess.close(batch);
            }
            this.commandCommitListeners.registerSuccess(batch, lastAppendIndex);
            return lastAppendIndex;
        }
        catch (Exception e) {
            this.commandCommitListeners.registerFailure(batch, e);
            throw e;
        }
    }

    private long appendToLog(StorageEngineTransaction batch, TransactionWriteEvent transactionWriteEvent) throws TransactionFailureException {
        long l;
        block8: {
            LogAppendEvent logAppendEvent = transactionWriteEvent.beginLogAppend();
            try {
                l = this.appender.append(batch, logAppendEvent);
                if (logAppendEvent == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (logAppendEvent != null) {
                        try {
                            logAppendEvent.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable cause) {
                    throw TransactionFailureException.couldNotAppendTransaction((String)batch.toString(), (Throwable)cause, (Log)this.log);
                }
            }
            logAppendEvent.close();
        }
        return l;
    }

    protected void applyToStore(StorageEngineTransaction batch, TransactionWriteEvent transactionWriteEvent, TransactionApplicationMode mode) throws TransactionFailureException {
        try (StoreApplyEvent storeApplyEvent = transactionWriteEvent.beginStoreApply();){
            this.storageEngine.apply(batch, mode);
        }
        catch (Throwable cause) {
            throw TransactionFailureException.couldNotApplyTransaction((String)batch.toString(), (Throwable)cause, (Log)this.log);
        }
    }

    private void preAllocateSpaceInStores(StorageEngineTransaction batch, TransactionApplicationMode mode) throws TransactionFailureException {
        try {
            this.storageEngine.preAllocateStoreFilesForCommands(batch, mode);
        }
        catch (OutOfDiskSpaceException oods) {
            throw TransactionFailureException.couldNotPreallocateDiskSpace((String)batch.toString(), (Status)Status.General.UnknownError, (Throwable)oods, (Log)this.log);
        }
        catch (Throwable cause) {
            throw TransactionFailureException.couldNotPreallocateDiskSpace((String)batch.toString(), (Status)Status.Transaction.TransactionCommitFailed, (Throwable)cause, (Log)this.log);
        }
    }

    private static void close(StorageEngineTransaction batch) {
        while (batch != null) {
            batch.close();
            batch = batch.next();
        }
    }
}

