/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.Set;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.neo4j.batchimport.api.BatchImporter;
import org.neo4j.batchimport.api.Configuration;
import org.neo4j.batchimport.api.IndexConfig;
import org.neo4j.batchimport.api.IndexImporterFactory;
import org.neo4j.batchimport.api.InputIterable;
import org.neo4j.batchimport.api.InputIterator;
import org.neo4j.batchimport.api.Monitor;
import org.neo4j.batchimport.api.input.Collector;
import org.neo4j.batchimport.api.input.IdType;
import org.neo4j.batchimport.api.input.Input;
import org.neo4j.batchimport.api.input.InputChunk;
import org.neo4j.batchimport.api.input.InputEntityVisitor;
import org.neo4j.batchimport.api.input.PropertySizeCalculator;
import org.neo4j.batchimport.api.input.ReadableGroups;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.internal.batchimport.DefaultAdditionalIds;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileHandle;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.mem.MemoryAllocator;
import org.neo4j.io.pagecache.ExternallyManagedPageCache;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.impl.muninn.swapper.PageSwapperFactory;
import org.neo4j.io.pagecache.impl.muninn.swapper.SingleFilePageSwapperFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.index.IndexProvidersAccess;
import org.neo4j.kernel.impl.index.schema.DefaultIndexProvidersAccess;
import org.neo4j.kernel.impl.index.schema.IndexImporterFactoryImpl;
import org.neo4j.kernel.impl.transaction.log.LogTailMetadata;
import org.neo4j.kernel.impl.transaction.log.LogTailMetadataFactory;
import org.neo4j.kernel.impl.transaction.log.files.LogTailMetadataFactoryImpl;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogInitializer;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.NullLogService;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StoreGenerator;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.StoreSeeder;

public class EmptyStoreSeeder
implements StoreGenerator,
StoreSeeder {
    private final Config config;
    private final FileSystemAbstraction fs;
    private final DatabaseLayout databaseLayout;
    private final JobScheduler jobScheduler;
    private final int numShards;

    public EmptyStoreSeeder(Config config, FileSystemAbstraction fs, DatabaseLayout databaseLayout, JobScheduler jobScheduler, int numShards) {
        this.config = config;
        this.fs = fs;
        this.databaseLayout = databaseLayout;
        this.jobScheduler = jobScheduler;
        this.numShards = numShards;
    }

    /*
     * Exception decompiling
     */
    public byte[] generateStore() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void seedStore(byte[] seed) throws IOException {
        Predicate<String> filter = this.pathFilter();
        try (ZipInputStream stream = new ZipInputStream(new ByteArrayInputStream(seed));){
            ZipEntry entry;
            while ((entry = stream.getNextEntry()) != null) {
                if (entry.isDirectory() || !filter.test(entry.getName())) continue;
                Path targetPath = this.databaseLayout.getNeo4jLayout().homeDirectory().resolve(entry.getName());
                Path directory = targetPath.getParent();
                if (!this.fs.fileExists(directory)) {
                    this.fs.mkdirs(directory);
                }
                OutputStream fileOutput = this.fs.openAsOutputStream(targetPath, false);
                try {
                    stream.transferTo(fileOutput);
                }
                finally {
                    if (fileOutput == null) continue;
                    fileOutput.close();
                }
            }
            return;
        }
    }

    public void validateStoreId(StoreId storeId) throws IOException {
        StorageEngineFactory storageEngineFactory = (StorageEngineFactory)StorageEngineFactory.selectStorageEngine((FileSystemAbstraction)this.fs, (DatabaseLayout)this.databaseLayout).orElseThrow();
        LogTailMetadata logTailMetadata = new LogTailMetadataFactoryImpl(this.fs).getLogTailMetadata(this.config, this.databaseLayout, storageEngineFactory);
        StoreId existingStoreId = (StoreId)logTailMetadata.getStoreId().orElseThrow();
        if (!existingStoreId.equals((Object)storeId)) {
            throw new IllegalStateException("Existing " + String.valueOf(existingStoreId) + " of " + String.valueOf(this.databaseLayout) + " doesn't match expected " + String.valueOf(storeId));
        }
    }

    private BatchImporter batchImporter(StorageEngineFactory storageEngineFactory, DatabaseLayout tempDatabaseLayout, final PageCache pageCache, IndexProvidersAccess indexProvidersAccess) {
        Configuration.Overridden configuration = new Configuration.Overridden(this, Configuration.DEFAULT){

            public ExternallyManagedPageCache providedPageCache() {
                return new ExternallyManagedPageCache(pageCache);
            }

            public IndexConfig indexConfig() {
                return IndexConfig.create().withLabelIndex().withRelationshipTypeIndex();
            }
        };
        return storageEngineFactory.batchImporter(tempDatabaseLayout, this.fs, true, PageCacheTracer.NULL, (Configuration)configuration, (LogService)NullLogService.getInstance(), new PrintStream(OutputStream.nullOutputStream()), false, DefaultAdditionalIds.EMPTY, this.withoutTxLogPreAllocation(this.config), Monitor.NO_MONITOR, this.jobScheduler, Collector.STRICT, TransactionLogInitializer.getLogFilesInitializer(), (IndexImporterFactory)new IndexImporterFactoryImpl(), (MemoryTracker)EmptyMemoryTracker.INSTANCE, CursorContextFactory.NULL_CONTEXT_FACTORY, this.numShards, (LogTailMetadataFactory)new LogTailMetadataFactoryImpl(this.fs), indexProvidersAccess);
    }

    private DefaultIndexProvidersAccess indexProviders(StorageEngineFactory storageEngineFactory) {
        return new DefaultIndexProvidersAccess(storageEngineFactory, this.fs, this.config, this.jobScheduler, (LogService)NullLogService.getInstance(), PageCacheTracer.NULL, CursorContextFactory.NULL_CONTEXT_FACTORY);
    }

    private DatabaseLayout cleanTempDatabaseLayout() throws IOException {
        Path tempDirectory = this.databaseLayout.databaseDirectory().resolve("temp-seed");
        this.fs.deleteRecursively(tempDirectory);
        this.fs.mkdirs(tempDirectory);
        return DatabaseLayout.of((Neo4jLayout)Neo4jLayout.of((Path)tempDirectory), (String)this.databaseLayout.getDatabaseName());
    }

    private Predicate<String> pathFilter() {
        Set<Path> prefixFilters = Set.of(this.databaseLayout.getNeo4jLayout().homeDirectory().relativize(this.databaseLayout.databaseDirectory()), this.databaseLayout.getNeo4jLayout().homeDirectory().relativize(this.databaseLayout.getTransactionLogsDirectory()));
        return entryName -> {
            Path entryPath = Path.of(entryName, new String[0]);
            while (entryPath.getNameCount() > 1) {
                if (prefixFilters.contains(entryPath)) {
                    return true;
                }
                entryPath = entryPath.getParent();
            }
            return false;
        };
    }

    private Config withoutTxLogPreAllocation(Config config) {
        return Config.newBuilder().fromConfig(config).set(GraphDatabaseSettings.preallocate_logical_logs, (Object)false).build();
    }

    private byte[] zip(FileSystemAbstraction fs, Path path) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (ZipOutputStream zip = new ZipOutputStream(byteArrayOutputStream);){
            for (FileHandle file : fs.streamFilesRecursive(path).toList()) {
                if (fs.isDirectory(file.getPath())) continue;
                zip.putNextEntry(new ZipEntry(path.relativize(file.getPath()).toString()));
                try (InputStream fileInput = fs.openAsInputStream(file.getPath());){
                    fileInput.transferTo(zip);
                }
                zip.closeEntry();
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    private PageCache openNonForcingSmallPageCache(FileSystemAbstraction fs, JobScheduler jobScheduler) {
        MuninnPageCache.Configuration config = MuninnPageCache.config((MemoryAllocator)MemoryAllocator.createAllocator((long)ByteUnit.mebiBytes((long)80L), (MemoryTracker)EmptyMemoryTracker.INSTANCE)).swapperFactory((PageSwapperFactory)new SingleFilePageSwapperFactory(fs, PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE, false));
        return new MuninnPageCache(fs, jobScheduler, config);
    }

    private static class NoInput
    implements Input {
        private NoInput() {
        }

        public InputIterable nodes(Collector badCollector) {
            return this.nothing();
        }

        private InputIterable nothing() {
            return new NoInputIterable();
        }

        public InputIterable relationships(Collector badCollector) {
            return new NoInputIterable();
        }

        public IdType idType() {
            return IdType.INTEGER;
        }

        public ReadableGroups groups() {
            return ReadableGroups.EMPTY;
        }

        public Input.Estimates validateAndEstimate(PropertySizeCalculator valueSizeCalculator) throws IOException {
            return new Input.Estimates(0L, 0L, 0L, 0L, 0L, 0L, 0L, false, false);
        }
    }

    private static class NoInputIterable
    implements InputIterable,
    InputIterator,
    InputChunk {
        private NoInputIterable() {
        }

        public InputIterator iterator() {
            return this;
        }

        public InputChunk newChunk() {
            return this;
        }

        public boolean next(InputChunk chunk) {
            return false;
        }

        public boolean next(InputEntityVisitor visitor) {
            return false;
        }

        public void close() {
        }
    }
}

