/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.vector;

import org.neo4j.kernel.api.vector.VectorNormalize;
import org.neo4j.kernel.api.vector.VectorUtil;
import org.neo4j.values.VectorCandidate;
import org.neo4j.values.storable.VectorValue;

public enum GQLVectorNormalize implements VectorNormalize
{
    EUCLIDEAN{

        public VectorValue normalize(VectorCandidate vector) {
            return VectorUtil.l2NormalizedVector(vector);
        }

        public boolean valid(VectorCandidate vector) {
            if (!VectorUtil.valid(vector)) {
                return false;
            }
            float norm = VectorUtil.l2Norm(vector);
            return Float.isFinite(norm) && norm > 0.0f;
        }
    }
    ,
    MANHATTAN{

        public VectorValue normalize(VectorCandidate vector) {
            return VectorUtil.l1NormalizedVector(vector);
        }

        public boolean valid(VectorCandidate vector) {
            if (!VectorUtil.valid(vector)) {
                return false;
            }
            float norm = VectorUtil.l1Norm(vector);
            return Float.isFinite(norm) && norm > 0.0f;
        }
    };

}

