/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import org.neo4j.common.TokenNameLookup;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.schema.ConstraintDescriptor;

public class UnableToValidateConstraintException
extends ConstraintValidationException {
    private UnableToValidateConstraintException(ErrorGqlStatusObject gqlStatusObject, ConstraintDescriptor constraint, Throwable cause, TokenNameLookup tokenNameLookup) {
        super(gqlStatusObject, constraint, ConstraintValidationException.Phase.VERIFICATION, String.format("Unable to validate constraint %s", constraint.userDescription(tokenNameLookup)), cause, tokenNameLookup);
    }

    public static UnableToValidateConstraintException unableToValidateConstraintException(ConstraintDescriptor constraint, Throwable cause, TokenNameLookup tokenNameLookup) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_50N13).withParam(GqlParams.StringParam.constrDescrOrName, constraint.userDescription(tokenNameLookup)).build();
        return new UnableToValidateConstraintException(gql, constraint, cause, tokenNameLookup);
    }

    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        return String.format("Unable to validate constraint %s", this.constraint.userDescription(tokenNameLookup));
    }
}

