/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import java.util.Iterator;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.dbms.database.AbstractVersionComponent;
import org.neo4j.dbms.database.ComponentVersion;
import org.neo4j.dbms.database.DbmsRuntimeVersion;
import org.neo4j.dbms.database.SystemGraphComponent;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterators;

public class DbmsRuntimeSystemGraphComponent
extends AbstractVersionComponent<DbmsRuntimeVersion> {
    public static final Label OLD_COMPONENT_LABEL = Label.label((String)"DbmsRuntime");
    public static final String OLD_PROPERTY_NAME = "version";
    private final DbmsRuntimeVersion fallbackVersion;

    public DbmsRuntimeSystemGraphComponent(Config config) {
        super(ComponentVersion.DBMS_RUNTIME_COMPONENT, DbmsRuntimeVersion.getLatestVersion(config), config, DbmsRuntimeVersion::fromVersionNumber);
        DbmsRuntimeVersion semanticFallbackVersion = DbmsRuntimeVersion.V5_0;
        this.fallbackVersion = (Boolean)config.get(GraphDatabaseInternalSettings.fallback_to_latest_runtime_version) != false ? (DbmsRuntimeVersion)this.latestVersion : semanticFallbackVersion;
    }

    @Override
    public DbmsRuntimeVersion getFallbackVersion() {
        return this.fallbackVersion;
    }

    @Override
    public Integer getVersion(Transaction tx, SystemGraphComponent.Name componentName) {
        Integer result = null;
        try (ResourceIterator nodes = tx.findNodes(OLD_COMPONENT_LABEL);){
            if (nodes.hasNext()) {
                Node versionNode = (Node)nodes.next();
                result = (Integer)versionNode.getProperty(OLD_PROPERTY_NAME, null);
            }
        }
        return result != null ? result : SystemGraphComponent.getVersionNumber(tx, componentName);
    }

    @Override
    public void upgradeToCurrent(GraphDatabaseService systemDb) throws Exception {
        SystemGraphComponent.executeWithFullAccess(systemDb, (ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> {
            Iterators.forEachRemaining((Iterator)tx.findNodes(OLD_COMPONENT_LABEL), Node::delete);
            this.setToLatestVersion((Transaction)tx);
        }));
    }

    public Config config() {
        return this.config;
    }
}

