/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import java.time.Duration;
import org.neo4j.kernel.api.exceptions.Status;

public record TransactionTimeout(long timeoutNanos, Status status) {
    private static final long SAFE_SECOND_BOUNDARY = 9223372035L;
    public static final TransactionTimeout NO_TIMEOUT = new TransactionTimeout(Duration.ZERO, (Status)Status.Transaction.TransactionTimedOut);

    public TransactionTimeout(Duration duration, Status status) {
        this(TransactionTimeout.convertToNanos(duration), status);
    }

    private static long convertToNanos(Duration timeout) {
        if (timeout.getSeconds() < 9223372035L) {
            return timeout.toNanos();
        }
        return Long.MAX_VALUE;
    }
}

