/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.internal.unsafe.UnsafeUtil;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.pagecache.impl.BlockSwapper;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;

final class UnsafeBlockSwapper
implements BlockSwapper {
    private static final ThreadLocal<ByteBuffer> PROXY_CACHE = new ThreadLocal();

    UnsafeBlockSwapper() {
    }

    private static ByteBuffer proxy(long buffer, int bufferLength) throws IOException {
        ByteBuffer buf = PROXY_CACHE.get();
        if (buf != null) {
            if (buf.capacity() != bufferLength) {
                return UnsafeBlockSwapper.createAndGetNewBuffer(buffer, bufferLength);
            }
            UnsafeUtil.initDirectByteBuffer((ByteBuffer)buf, (long)buffer, (int)bufferLength);
            return buf;
        }
        return UnsafeBlockSwapper.createAndGetNewBuffer(buffer, bufferLength);
    }

    private static ByteBuffer createAndGetNewBuffer(long buffer, int bufferLength) throws IOException {
        ByteBuffer buf;
        try {
            buf = UnsafeUtil.newDirectByteBuffer((long)buffer, (int)bufferLength);
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
        PROXY_CACHE.set(buf);
        return buf;
    }

    @Override
    public int swapIn(StoreChannel channel, long bufferAddress, long fileOffset, int bufferSize) throws IOException {
        int readTotal = 0;
        try {
            int read;
            ByteBuffer bufferProxy = UnsafeBlockSwapper.proxy(bufferAddress, bufferSize);
            while ((read = channel.read(bufferProxy, fileOffset + (long)readTotal)) != -1 && (readTotal += read) < bufferSize) {
            }
            int rest = bufferSize - readTotal;
            if (rest > 0) {
                UnsafeUtil.setMemory((long)(bufferAddress + (long)readTotal), (long)rest, (byte)MuninnPageCache.ZERO_BYTE);
            }
            return readTotal;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IOException(UnsafeBlockSwapper.formatSwapInErrorMessage(fileOffset, bufferSize, readTotal), e);
        }
    }

    private static String formatSwapInErrorMessage(long fileOffset, int size, int readTotal) {
        return "Read failed after " + readTotal + " of " + size + " bytes from fileOffset " + fileOffset + ".";
    }

    @Override
    public void swapOut(StoreChannel channel, long bufferAddress, long fileOffset, int bufferLength) throws IOException {
        try {
            ByteBuffer bufferProxy = UnsafeBlockSwapper.proxy(bufferAddress, bufferLength);
            channel.writeAll(bufferProxy, fileOffset);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
    }
}

