/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.context;

import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.util.concurrent.OutOfOrderSequence;

public record TransactionIdSnapshot(long lastClosedTxId, long highestEverSeen, long[] notVisibleTransactions) {
    public static final TransactionIdSnapshot EMPTY_ID_SNAPSHOT = new TransactionIdSnapshot(1L);

    public TransactionIdSnapshot(long lastClosedTxId) {
        this(lastClosedTxId, lastClosedTxId, ArrayUtils.EMPTY_LONG_ARRAY);
    }

    public TransactionIdSnapshot(OutOfOrderSequence.ReverseSnapshot reverseSnapshot) {
        this(reverseSnapshot.highestGapFree(), reverseSnapshot.highestEverSeen(), reverseSnapshot.missingIds());
    }

    public static boolean isNotVisible(long[] notVisibleVersions, long version) {
        if (notVisibleVersions.length == 0) {
            return false;
        }
        return Arrays.binarySearch(notVisibleVersions, version) >= 0;
    }

    @Override
    public String toString() {
        return "TransactionIdSnapshot{lastClosedTxId=" + this.lastClosedTxId + ", highestEverSeen=" + this.highestEverSeen + ", notVisibleTransactions=" + Arrays.toString(this.notVisibleTransactions) + "}";
    }
}

