/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.Path;
import java.util.function.Consumer;

public interface FileHandle {
    public static final Consumer<FileHandle> HANDLE_DELETE = fh -> {
        try {
            fh.delete();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    };

    public static Consumer<FileHandle> handleRename(Path to) {
        return fileHandle -> {
            try {
                fileHandle.rename(to, new CopyOption[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    public Path getPath();

    public Path getRelativePath();

    public void rename(Path var1, CopyOption ... var2) throws IOException;

    public void delete() throws IOException;
}

