/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.state;

import java.io.IOException;
import java.nio.file.Path;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.InputStreamReadableChannel;
import org.neo4j.io.fs.OutputStreamWritableChannel;
import org.neo4j.io.marshal.ChannelMarshal;
import org.neo4j.io.marshal.EndOfStreamException;
import org.neo4j.io.state.SimpleStorage;

public class SimpleFileStorage<T>
implements SimpleStorage<T> {
    protected final FileSystemAbstraction fileSystem;
    protected final ChannelMarshal<T> marshal;
    protected final Path path;

    public SimpleFileStorage(FileSystemAbstraction fileSystem, Path path, ChannelMarshal<T> marshal) {
        this.fileSystem = fileSystem;
        this.path = path;
        this.marshal = marshal;
    }

    @Override
    public boolean exists() {
        return this.fileSystem.fileExists(this.path);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T readState() throws IOException {
        try (InputStreamReadableChannel channel = new InputStreamReadableChannel(this.fileSystem.openAsInputStream(this.path));){
            T t = this.marshal.unmarshal(channel);
            return t;
        }
        catch (EndOfStreamException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeState(T state) throws IOException {
        if (this.path.getParent() != null) {
            this.fileSystem.mkdirs(this.path.getParent());
        }
        if (this.fileSystem.fileExists(this.path)) {
            this.fileSystem.deleteFile(this.path);
        }
        try (OutputStreamWritableChannel channel = new OutputStreamWritableChannel(this.fileSystem.openAsOutputStream(this.path, false));){
            this.marshal.marshal(state, channel);
        }
    }

    @Override
    public void removeState() throws IOException {
        if (this.exists()) {
            this.fileSystem.deleteFile(this.path);
        }
    }
}

