/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.mem.MemoryAllocator;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;

public final class StandalonePageCacheFactory {
    private StandalonePageCacheFactory() {
    }

    public static PageCache createPageCache(FileSystemAbstraction fileSystem, JobScheduler jobScheduler, PageCacheTracer cacheTracer) {
        return StandalonePageCacheFactory.createPageCache(fileSystem, jobScheduler, cacheTracer, 8192);
    }

    public static PageCache createPageCache(FileSystemAbstraction fileSystem, JobScheduler jobScheduler) {
        return StandalonePageCacheFactory.createPageCache(fileSystem, jobScheduler, PageCacheTracer.NULL, 8192);
    }

    public static PageCache createPageCache(FileSystemAbstraction fileSystem, JobScheduler jobScheduler, int pageSize) {
        return StandalonePageCacheFactory.createPageCache(fileSystem, jobScheduler, PageCacheTracer.NULL, pageSize);
    }

    private static PageCache createPageCache(FileSystemAbstraction fileSystemAbstraction, JobScheduler jobScheduler, PageCacheTracer cacheTracer, int pageSize) {
        long expectedMemory = Math.max(ByteUnit.MebiByte.toBytes(8L), 10L * (long)pageSize);
        MemoryAllocator memoryAllocator = MemoryAllocator.createAllocator(expectedMemory, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        MuninnPageCache.Configuration configuration = MuninnPageCache.config(memoryAllocator).pageCacheTracer(cacheTracer).pageSize(pageSize);
        return StandalonePageCacheFactory.createPageCache(fileSystemAbstraction, configuration, jobScheduler);
    }

    public static PageCache createPageCache(FileSystemAbstraction fileSystem, JobScheduler jobScheduler, PageCacheTracer cacheTracer, MuninnPageCache.Configuration configuration) {
        configuration.pageCacheTracer(cacheTracer);
        return StandalonePageCacheFactory.createPageCache(fileSystem, configuration, jobScheduler);
    }

    private static MuninnPageCache createPageCache(FileSystemAbstraction fileSystemAbstraction, MuninnPageCache.Configuration configuration, JobScheduler jobScheduler) {
        return new MuninnPageCache(fileSystemAbstraction, jobScheduler, configuration);
    }
}

