/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.context;

import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.io.pagecache.context.VersionContext;

public class UnboundedReadVersionContext
implements VersionContext {
    private static final long INVALID_TRANSACTION_ID = 0L;
    private long committingTransactionId = 0L;
    private long committingAppendIndex = 0L;

    public UnboundedReadVersionContext(long committingTransactionId, long committingAppendIndex) {
        this.committingTransactionId = committingTransactionId;
        this.committingAppendIndex = committingAppendIndex;
    }

    @Override
    public void initRead() {
    }

    @Override
    public void initWrite(long committingTransactionId) {
        this.committingTransactionId = committingTransactionId;
    }

    @Override
    public long committingTransactionId() {
        return this.committingTransactionId;
    }

    @Override
    public void initAppendIndex(long committingAppendIndex) {
        this.committingAppendIndex = committingAppendIndex;
    }

    @Override
    public long committingAppendIndex() {
        return this.committingAppendIndex;
    }

    @Override
    public long lastClosedTransactionId() {
        return Long.MAX_VALUE;
    }

    @Override
    public long highestClosed() {
        return Long.MAX_VALUE;
    }

    @Override
    public void markAsDirty() {
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public long[] notVisibleTransactionIds() {
        return ArrayUtils.EMPTY_LONG_ARRAY;
    }

    @Override
    public long oldestVisibleTransactionNumber() {
        return 0L;
    }

    @Override
    public void refreshVisibilityBoundaries() {
    }

    @Override
    public void observedChainHead(long headVersion) {
    }

    @Override
    public boolean invisibleHeadObserved() {
        return false;
    }

    @Override
    public void resetObsoleteHeadState() {
    }

    @Override
    public void markHeadInvisible() {
    }

    @Override
    public long chainHeadVersion() {
        return Long.MIN_VALUE;
    }

    @Override
    public boolean initializedForWrite() {
        return this.committingTransactionId != 0L;
    }

    @Override
    public int stamp() {
        return 0;
    }

    @Override
    public boolean validateStamp(int stamp) {
        return true;
    }

    public String toString() {
        return "UnboundedReadVersionContext{transactionId=" + this.committingTransactionId + ", appendIndex=" + this.committingAppendIndex + "}";
    }
}

