/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.memory;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.internal.utils.DumpUtils;

public sealed interface BufferLeakTracker {
    public static final BufferLeakTracker DISABLED_TRACKER = new EmptyDefaultBufferLeakTracker();
    public static final BufferLeakTracker ENABLED_TRACKER = new TrackingBufferLeakTracker();

    public ByteBuffer track(ByteBuffer var1);

    public void release(ByteBuffer var1);

    public void checkLeaks(Supplier<String> var1);

    public static final class EmptyDefaultBufferLeakTracker
    implements BufferLeakTracker {
        private EmptyDefaultBufferLeakTracker() {
        }

        @Override
        public ByteBuffer track(ByteBuffer buffer) {
            return buffer;
        }

        @Override
        public void release(ByteBuffer byteBuffer) {
        }

        @Override
        public void checkLeaks(Supplier<String> testPlanDescriptionProvider) {
        }
    }

    public static final class TrackingBufferLeakTracker
    implements BufferLeakTracker {
        private final Map<ByteBuffer, Exception> trackerBuffers = Collections.synchronizedMap(new IdentityHashMap());

        private TrackingBufferLeakTracker() {
        }

        @Override
        public ByteBuffer track(ByteBuffer buffer) {
            this.trackerBuffers.put(buffer, new RuntimeException("Buffer allocation"));
            return buffer;
        }

        @Override
        public void release(ByteBuffer byteBuffer) {
            this.trackerBuffers.remove(byteBuffer);
        }

        @Override
        public void checkLeaks(Supplier<String> testPlanDescriptionProvider) {
            if (this.trackerBuffers.isEmpty()) {
                return;
            }
            StringBuilder exceptionBuilder = new StringBuilder("                                      ***WARNING***\nNative buffer leak(s) has been detected by the buffer leak tracker. The test session will be marked as failed.\nPlease review the details of unreleased allocations from the tests executed in the current session below.\nLast executed tests:\n");
            exceptionBuilder.append(testPlanDescriptionProvider.get()).append(System.lineSeparator()).append(System.lineSeparator());
            exceptionBuilder.append("Leakage traces:").append(System.lineSeparator());
            for (Map.Entry<ByteBuffer, Exception> entry : this.trackerBuffers.entrySet()) {
                exceptionBuilder.append("Leaked buffer: ").append(entry.getKey()).append(" allocated at: ").append(Exceptions.stringify((Throwable)entry.getValue()));
            }
            exceptionBuilder.append("All active threads dump:").append(System.lineSeparator());
            exceptionBuilder.append(DumpUtils.threadDump());
            throw new RuntimeException(exceptionBuilder.toString());
        }
    }
}

