/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.neo4j.index.internal.gbptree.CleanupJob;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobMonitoringParams;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.util.Preconditions;

public class GroupingRecoveryCleanupWorkCollector
extends RecoveryCleanupWorkCollector {
    private final BlockingQueue<CleanupJob> jobs = new LinkedBlockingQueue<CleanupJob>();
    private final JobScheduler jobScheduler;
    private final Group group;
    private final Group workerGroup;
    private final String databaseName;
    private volatile boolean moreJobsAllowed = true;
    private volatile JobHandle handle;

    public GroupingRecoveryCleanupWorkCollector(JobScheduler jobScheduler, Group group, Group workerGroup, String databaseName) {
        this.jobScheduler = jobScheduler;
        this.group = group;
        this.workerGroup = workerGroup;
        this.databaseName = databaseName;
    }

    public void init() {
        this.scheduleJobs();
    }

    @Override
    public synchronized void add(CleanupJob job) {
        Preconditions.checkState((boolean)this.moreJobsAllowed, (String)"Index clean jobs can't be added after collector start.");
        this.jobs.add(job);
    }

    public synchronized void start() {
        Preconditions.checkState((boolean)this.moreJobsAllowed, (String)"Already started");
        this.moreJobsAllowed = false;
    }

    public synchronized void stop() throws ExecutionException, InterruptedException {
        CleanupJob job;
        this.moreJobsAllowed = false;
        if (this.handle != null) {
            this.handle.waitTermination();
        }
        while ((job = (CleanupJob)this.jobs.poll()) != null) {
            job.close();
        }
    }

    private void scheduleJobs() {
        this.handle = this.jobScheduler.schedule(this.group, JobMonitoringParams.systemJob((String)this.databaseName, (String)"Index recovery clean up"), this.allJobs());
    }

    private Runnable allJobs() {
        return () -> {
            CleanupJob job = null;
            do {
                try {
                    job = this.jobs.poll(100L, TimeUnit.MILLISECONDS);
                    if (job == null) continue;
                    job.run(new CleanupJob.Executor(){

                        @Override
                        public <T> CleanupJob.JobResult<T> submit(String jobDescription, Callable<T> job) {
                            JobMonitoringParams jobMonitoringParams = JobMonitoringParams.systemJob((String)GroupingRecoveryCleanupWorkCollector.this.databaseName, (String)jobDescription);
                            JobHandle jobHandle = GroupingRecoveryCleanupWorkCollector.this.jobScheduler.schedule(GroupingRecoveryCleanupWorkCollector.this.workerGroup, jobMonitoringParams, job);
                            return () -> ((JobHandle)jobHandle).get();
                        }
                    });
                }
                catch (Exception exception) {
                }
                finally {
                    if (job != null) {
                        job.close();
                    }
                }
            } while (!this.jobs.isEmpty() || this.moreJobsAllowed);
        };
    }
}

