/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.util.Objects;
import org.neo4j.index.internal.gbptree.TreeNode;

public interface GBPTreePointerType {
    public int offset(TreeNode var1);

    public static GBPTreePointerType leftSibling() {
        return SimplePointer.LEFT_SIBLING;
    }

    public static GBPTreePointerType rightSibling() {
        return SimplePointer.RIGHT_SIBLING;
    }

    public static GBPTreePointerType successor() {
        return SimplePointer.SUCCESSOR;
    }

    public static GBPTreePointerType noPointer() {
        return SimplePointer.NO_POINTER;
    }

    public static GBPTreePointerType child(int pos) {
        return new ChildPointer(pos);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum SimplePointer implements GBPTreePointerType
    {
        NO_POINTER{

            @Override
            public int offset(TreeNode node) {
                return 0;
            }

            public String toString() {
                return "no pointer";
            }
        }
        ,
        LEFT_SIBLING{

            @Override
            public int offset(TreeNode node) {
                return 34;
            }

            public String toString() {
                return "left sibling";
            }
        }
        ,
        RIGHT_SIBLING{

            @Override
            public int offset(TreeNode node) {
                return 10;
            }

            public String toString() {
                return "right sibling";
            }
        }
        ,
        SUCCESSOR{

            @Override
            public int offset(TreeNode node) {
                return 58;
            }

            public String toString() {
                return "successor";
            }
        };

    }

    public static class ChildPointer
    implements GBPTreePointerType {
        private final int pos;

        ChildPointer(int pos) {
            this.pos = pos;
        }

        @Override
        public int offset(TreeNode node) {
            return node.childOffset(this.pos);
        }

        public String toString() {
            return "child(" + this.pos + ")";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChildPointer that = (ChildPointer)o;
            return this.pos == that.pos;
        }

        public int hashCode() {
            return Objects.hash(this.pos);
        }
    }
}

