/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.LongList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.index.internal.gbptree.CursorCreator;
import org.neo4j.index.internal.gbptree.GBPTreeConsistencyCheckVisitor;
import org.neo4j.index.internal.gbptree.GBPTreeGenerationTarget;
import org.neo4j.index.internal.gbptree.GBPTreePointerType;
import org.neo4j.index.internal.gbptree.GenerationKeeper;
import org.neo4j.index.internal.gbptree.GenerationSafePointer;
import org.neo4j.index.internal.gbptree.GenerationSafePointerPair;
import org.neo4j.index.internal.gbptree.IdProvider;
import org.neo4j.index.internal.gbptree.KeyRange;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.PointerChecking;
import org.neo4j.index.internal.gbptree.RightmostInChain;
import org.neo4j.index.internal.gbptree.Root;
import org.neo4j.index.internal.gbptree.TreeNode;
import org.neo4j.index.internal.gbptree.TreeNodeUtil;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.internal.helpers.NamedThreadFactory;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.pagecache.CursorException;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.util.concurrent.Futures;

class GBPTreeConsistencyChecker<KEY> {
    private static final String TAG_CHECK = "check gbptree consistency";
    private final TreeNode<KEY, ?> node;
    private final Comparator<KEY> comparator;
    private final Layout<KEY, ?> layout;
    private final ConsistencyCheckState state;
    private final long stableGeneration;
    private final long unstableGeneration;
    private final boolean reportDirty;
    private final Path file;
    private final ThrowingFunction<CursorContext, PageCursor, IOException> cursorFactory;
    private final Root root;
    private final CursorContextFactory contextFactory;
    private final int numThreads;
    static Monitor NO_MONITOR = keyCount -> {};

    GBPTreeConsistencyChecker(TreeNode<KEY, ?> node, Layout<KEY, ?> layout, ConsistencyCheckState state, int numThreads, long stableGeneration, long unstableGeneration, boolean reportDirty, Path file, ThrowingFunction<CursorContext, PageCursor, IOException> cursorFactory, Root root, CursorContextFactory contextFactory) {
        this.node = node;
        this.comparator = node.keyComparator();
        this.layout = layout;
        this.state = state;
        this.numThreads = numThreads;
        this.stableGeneration = stableGeneration;
        this.unstableGeneration = unstableGeneration;
        this.reportDirty = reportDirty;
        this.file = file;
        this.cursorFactory = cursorFactory;
        this.root = root;
        this.contextFactory = contextFactory;
    }

    void check(GBPTreeConsistencyCheckVisitor visitor, ProgressListener progress, Monitor monitor) throws IOException {
        try (CursorContext context = this.contextFactory.create(TAG_CHECK);
             PageCursor cursor = (PageCursor)this.cursorFactory.apply((Object)context);){
            long rootGeneration = this.root.goTo(cursor);
            KeyRange<Object> openRange = new KeyRange<Object>(-1, -1L, this.comparator, null, null, this.layout, null);
            RightmostInChainShard rightmostPerLevel = new RightmostInChainShard(this.file, true);
            this.checkSubtree(cursor, openRange, -1L, rootGeneration, GBPTreePointerType.noPointer(), 0, visitor, this.state.threadLocalSeenIds(), context, rightmostPerLevel, progress, monitor);
            rightmostPerLevel.assertLast(visitor);
        }
    }

    private static void addToSeenList(Path file, BitSet target, long id, long lastId, GBPTreeConsistencyCheckVisitor visitor) {
        int index = Math.toIntExact(id);
        if (target.get(index)) {
            visitor.pageIdSeenMultipleTimes(id, file);
        }
        if (id > lastId) {
            visitor.pageIdExceedLastId(lastId, id, file);
        }
        target.set(index);
    }

    private void checkSubtree(PageCursor cursor, KeyRange<KEY> range, long parentNode, long pointerGeneration, GBPTreePointerType parentPointerType, int level, GBPTreeConsistencyCheckVisitor visitor, BitSet seenIds, CursorContext cursorContext, RightmostInChainShard rightmostPerLevel, ProgressListener progress, Monitor monitor) throws IOException {
        boolean consistentNodeMeta;
        String nodeMetaReport;
        boolean isInternal;
        byte treeNodeType;
        byte nodeType;
        int keyCount;
        long successor;
        long currentNodeGeneration;
        long rightSiblingPointerGeneration;
        long rightSiblingPointer;
        long leftSiblingPointerGeneration;
        long leftSiblingPointer;
        long pageId = cursor.getCurrentPageId();
        GBPTreeConsistencyChecker.addToSeenList(this.file, seenIds, pageId, this.state.lastId, visitor);
        progress.add(1L);
        if (range.hasPageIdInStack(pageId)) {
            visitor.childNodeFoundAmongParentNodes(range, level, pageId, this.file);
            return;
        }
        GenerationKeeper generationTarget = new GenerationKeeper();
        do {
            leftSiblingPointer = TreeNodeUtil.leftSibling(cursor, this.stableGeneration, this.unstableGeneration, generationTarget);
            leftSiblingPointerGeneration = generationTarget.generation;
            rightSiblingPointer = TreeNodeUtil.rightSibling(cursor, this.stableGeneration, this.unstableGeneration, generationTarget);
            rightSiblingPointerGeneration = generationTarget.generation;
            leftSiblingPointer = GenerationSafePointerPair.pointer(leftSiblingPointer);
            rightSiblingPointer = GenerationSafePointerPair.pointer(rightSiblingPointer);
            currentNodeGeneration = TreeNodeUtil.generation(cursor);
            successor = TreeNodeUtil.successor(cursor, this.stableGeneration, this.unstableGeneration, generationTarget);
            keyCount = TreeNodeUtil.keyCount(cursor);
            nodeType = TreeNodeUtil.nodeType(cursor);
            treeNodeType = TreeNodeUtil.treeNodeType(cursor);
        } while (cursor.shouldRetry());
        GBPTreeConsistencyChecker.checkAfterShouldRetry(cursor);
        if (nodeType != 1) {
            visitor.notATreeNode(pageId, this.file);
            return;
        }
        boolean isLeaf = treeNodeType == 1;
        boolean bl = isInternal = treeNodeType == 0;
        if (!isInternal && !isLeaf) {
            visitor.unknownTreeNodeType(pageId, treeNodeType, this.file);
            return;
        }
        GBPTreeConsistencyChecker.assertNoCrashOrBrokenPointerInGSPP(this.file, cursor, this.stableGeneration, this.unstableGeneration, GBPTreePointerType.leftSibling(), 34, visitor, this.reportDirty);
        GBPTreeConsistencyChecker.assertNoCrashOrBrokenPointerInGSPP(this.file, cursor, this.stableGeneration, this.unstableGeneration, GBPTreePointerType.rightSibling(), 10, visitor, this.reportDirty);
        GBPTreeConsistencyChecker.assertNoCrashOrBrokenPointerInGSPP(this.file, cursor, this.stableGeneration, this.unstableGeneration, GBPTreePointerType.successor(), 58, visitor, this.reportDirty);
        boolean reasonableKeyCount = this.node.reasonableKeyCount(keyCount);
        if (!reasonableKeyCount) {
            visitor.unreasonableKeyCount(pageId, keyCount, this.file);
        } else {
            LongList offloadIds = this.assertKeyOrder(cursor, range, keyCount, isLeaf ? TreeNode.Type.LEAF : TreeNode.Type.INTERNAL, visitor, cursorContext);
            offloadIds.forEach((LongProcedure & Serializable)id -> GBPTreeConsistencyChecker.addToSeenList(this.file, seenIds, id, this.state.lastId, visitor));
        }
        do {
            nodeMetaReport = this.node.checkMetaConsistency(cursor, keyCount, isLeaf ? TreeNode.Type.LEAF : TreeNode.Type.INTERNAL, visitor);
            consistentNodeMeta = nodeMetaReport.isEmpty();
        } while (cursor.shouldRetry());
        GBPTreeConsistencyChecker.checkAfterShouldRetry(cursor);
        if (!consistentNodeMeta) {
            visitor.nodeMetaInconsistency(pageId, nodeMetaReport, this.file);
        }
        this.assertPointerGenerationMatchesGeneration(parentPointerType, parentNode, pageId, pointerGeneration, currentNodeGeneration, visitor);
        rightmostPerLevel.forLevel(level).assertNext(cursor, currentNodeGeneration, leftSiblingPointer, leftSiblingPointerGeneration, rightSiblingPointer, rightSiblingPointerGeneration, visitor);
        this.checkSuccessorPointerGeneration(cursor, successor, visitor);
        if (!(isInternal && reasonableKeyCount && consistentNodeMeta)) {
            if (isLeaf) {
                monitor.dataKeysSeen(keyCount);
            }
            return;
        }
        if (level == 0 && this.numThreads > 1) {
            ArrayList futures = new ArrayList();
            ArrayList<RightmostInChainShard> rightmostPerLevelFromShards = new ArrayList<RightmostInChainShard>();
            this.visitChildren(cursor, range, keyCount, level, visitor, cursorContext, generationTarget, (pos, treeNodeId, generation, childRange) -> {
                RightmostInChainShard shardRightmostPerLevel = new RightmostInChainShard(this.file, pos == 0);
                rightmostPerLevelFromShards.add(shardRightmostPerLevel);
                futures.add(this.state.executor.submit(() -> {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.getAnalysis(Method.java:520)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:351)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }));
            });
            GBPTreeConsistencyChecker.awaitAllFutures(futures);
            GBPTreeConsistencyChecker.checkRightmostInChainSeams(visitor, rightmostPerLevelFromShards);
        } else {
            this.visitChildren(cursor, range, keyCount, level, visitor, cursorContext, generationTarget, (pos, treeNodeId, generation, childRange) -> {
                TreeNodeUtil.goTo(cursor, "child at pos " + pos, treeNodeId);
                this.checkSubtree(cursor, childRange, pageId, generation, GBPTreePointerType.child(pos), level + 1, visitor, seenIds, cursorContext, rightmostPerLevel, progress, monitor);
                TreeNodeUtil.goTo(cursor, "parent", pageId);
            });
        }
    }

    private static void checkRightmostInChainSeams(GBPTreeConsistencyCheckVisitor visitor, List<RightmostInChainShard> rightmostPerLevelFromShards) {
        if (!rightmostPerLevelFromShards.isEmpty()) {
            RightmostInChainShard totalRightmost = rightmostPerLevelFromShards.get(0);
            for (int i = 1; i < rightmostPerLevelFromShards.size(); ++i) {
                RightmostInChainShard shard = rightmostPerLevelFromShards.get(i);
                totalRightmost.assertAndMergeNext(shard, visitor);
            }
            totalRightmost.assertLast(visitor);
        }
    }

    private static void awaitAllFutures(Iterable<Future<?>> futures) throws IOException {
        try {
            Futures.getAll(futures);
        }
        catch (ExecutionException e) {
            Throwable cause = Exceptions.findCauseOrSuppressed((Throwable)e, t -> !(t instanceof ExecutionException)).orElse(e);
            Exceptions.throwIfInstanceOfOrUnchecked((Throwable)cause, IOException.class, IOException::new);
        }
    }

    private void assertPointerGenerationMatchesGeneration(GBPTreePointerType pointerType, long sourceNode, long pointer, long pointerGeneration, long targetNodeGeneration, GBPTreeConsistencyCheckVisitor visitor) {
        if (targetNodeGeneration > pointerGeneration) {
            visitor.pointerHasLowerGenerationThanNode(pointerType, sourceNode, pointerGeneration, pointer, targetNodeGeneration, this.file);
        }
    }

    private void checkSuccessorPointerGeneration(PageCursor cursor, long successor, GBPTreeConsistencyCheckVisitor visitor) {
        if (TreeNodeUtil.isNode(successor)) {
            visitor.pointerToOldVersionOfTreeNode(cursor.getCurrentPageId(), GenerationSafePointerPair.pointer(successor), this.file);
        }
    }

    private void visitChildren(PageCursor cursor, KeyRange<KEY> range, int keyCount, int level, GBPTreeConsistencyCheckVisitor visitor, CursorContext cursorContext, GenerationKeeper generationTarget, ChildVisitor<KEY> childVisitor) throws IOException {
        long childGeneration;
        long child;
        int pos;
        long pageId = cursor.getCurrentPageId();
        Object prev = this.layout.newKey();
        for (pos = 0; pos < keyCount; ++pos) {
            long childGeneration2;
            long child2;
            Object readKey = this.layout.newKey();
            GBPTreeConsistencyChecker.assertNoCrashOrBrokenPointerInGSPP(this.file, cursor, this.stableGeneration, this.unstableGeneration, GBPTreePointerType.child(pos), this.node.childOffset(pos), visitor, this.reportDirty);
            do {
                child2 = this.childAt(cursor, pos, generationTarget);
                childGeneration2 = generationTarget.generation;
                this.node.keyAt(cursor, readKey, pos, TreeNode.Type.INTERNAL, cursorContext);
            } while (cursor.shouldRetry());
            GBPTreeConsistencyChecker.checkAfterShouldRetry(cursor);
            KeyRange childRange = range.newSubRange(level, pageId).restrictRight(readKey);
            if (pos > 0) {
                childRange = childRange.restrictLeft(prev);
            }
            childVisitor.accept(pos, child2, childGeneration2, childRange);
            this.layout.copyKey(readKey, prev);
        }
        GBPTreeConsistencyChecker.assertNoCrashOrBrokenPointerInGSPP(this.file, cursor, this.stableGeneration, this.unstableGeneration, GBPTreePointerType.child(pos), this.node.childOffset(pos), visitor, this.reportDirty);
        do {
            child = this.childAt(cursor, pos, generationTarget);
            childGeneration = generationTarget.generation;
        } while (cursor.shouldRetry());
        GBPTreeConsistencyChecker.checkAfterShouldRetry(cursor);
        KeyRange<KEY> childRange = range.newSubRange(level, pageId).restrictLeft(prev);
        childVisitor.accept(pos, child, childGeneration, childRange);
    }

    private static void checkAfterShouldRetry(PageCursor cursor) throws CursorException {
        PointerChecking.checkOutOfBounds(cursor);
        cursor.checkAndClearCursorException();
    }

    private long childAt(PageCursor cursor, int pos, GBPTreeGenerationTarget childGeneration) {
        return this.node.childAt(cursor, pos, this.stableGeneration, this.unstableGeneration, childGeneration);
    }

    private LongList assertKeyOrder(PageCursor cursor, KeyRange<KEY> range, int keyCount, TreeNode.Type type, GBPTreeConsistencyCheckVisitor visitor, CursorContext cursorContext) throws IOException {
        DelayedVisitor delayedVisitor = new DelayedVisitor(this.file);
        MutableLongList offloadIds = LongLists.mutable.empty();
        do {
            delayedVisitor.clear();
            offloadIds.clear();
            Object prev = this.layout.newKey();
            Object readKey = this.layout.newKey();
            boolean first = true;
            for (int pos = 0; pos < keyCount; ++pos) {
                this.node.keyAt(cursor, readKey, pos, type, cursorContext);
                if (!range.inRange(readKey)) {
                    Object keyCopy = this.layout.newKey();
                    this.layout.copyKey(readKey, keyCopy);
                    delayedVisitor.keysLocatedInWrongNode(range, keyCopy, pos, keyCount, cursor.getCurrentPageId(), this.file);
                }
                if (!first) {
                    if (this.comparator.compare(prev, readKey) >= 0) {
                        delayedVisitor.keysOutOfOrderInNode(cursor.getCurrentPageId(), this.file);
                    }
                } else {
                    first = false;
                }
                this.layout.copyKey(readKey, prev);
                long offloadId = this.node.offloadIdAt(cursor, pos, type);
                if (offloadId == -1L) continue;
                offloadIds.add(offloadId);
            }
        } while (cursor.shouldRetry());
        GBPTreeConsistencyChecker.checkAfterShouldRetry(cursor);
        delayedVisitor.report(visitor);
        return offloadIds;
    }

    static void assertNoCrashOrBrokenPointerInGSPP(Path file, PageCursor cursor, long stableGeneration, long unstableGeneration, GBPTreePointerType pointerType, int offset, GBPTreeConsistencyCheckVisitor visitor, boolean reportDirty) throws IOException {
        byte stateB;
        long pointerB;
        long readPointerB;
        long generationB;
        byte stateA;
        long pointerA;
        long readPointerA;
        long generationA;
        long currentNodeId = cursor.getCurrentPageId();
        do {
            cursor.setOffset(offset);
            generationA = GenerationSafePointer.readGeneration(cursor);
            readPointerA = GenerationSafePointer.readPointer(cursor);
            pointerA = GenerationSafePointerPair.pointer(readPointerA);
            short checksumA = GenerationSafePointer.readChecksum(cursor);
            boolean correctChecksumA = GenerationSafePointer.checksumOf(generationA, readPointerA) == checksumA;
            stateA = GenerationSafePointerPair.pointerState(stableGeneration, unstableGeneration, generationA, readPointerA, correctChecksumA);
            generationB = GenerationSafePointer.readGeneration(cursor);
            readPointerB = GenerationSafePointer.readPointer(cursor);
            pointerB = GenerationSafePointerPair.pointer(readPointerA);
            short checksumB = GenerationSafePointer.readChecksum(cursor);
            boolean correctChecksumB = GenerationSafePointer.checksumOf(generationB, readPointerB) == checksumB;
            stateB = GenerationSafePointerPair.pointerState(stableGeneration, unstableGeneration, generationB, readPointerB, correctChecksumB);
        } while (cursor.shouldRetry());
        if (reportDirty && (stateA == 2 || stateB == 2)) {
            visitor.crashedPointer(currentNodeId, pointerType, generationA, readPointerA, pointerA, stateA, generationB, readPointerB, pointerB, stateB, file);
        }
        if (stateA == 3 || stateB == 3) {
            visitor.brokenPointer(currentNodeId, pointerType, generationA, readPointerA, pointerA, stateA, generationB, readPointerB, pointerB, stateB, file);
        }
    }

    static class ConsistencyCheckState
    implements AutoCloseable {
        private final Path file;
        private final long lastId;
        private final GBPTreeConsistencyCheckVisitor visitor;
        private final List<BitSet> allThreadLocalSeenIds = Collections.synchronizedList(new ArrayList());
        private final ThreadLocal<BitSet> threadLocalSeenIds;
        private final BitSet mainSeenIds;
        final ExecutorService executor;
        final ProgressListener progress;
        final int numThreads;

        ConsistencyCheckState(Path file, IdProvider idProvider, GBPTreeConsistencyCheckVisitor visitor, CursorCreator cursorCreator, int numThreads, ProgressMonitorFactory progressMonitorFactory) throws IOException {
            this.file = file;
            this.lastId = idProvider.lastId();
            this.numThreads = numThreads;
            this.threadLocalSeenIds = ThreadLocal.withInitial(() -> {
                BitSet seenIds = new BitSet(Math.toIntExact(this.highId()));
                this.allThreadLocalSeenIds.add(seenIds);
                return seenIds;
            });
            this.mainSeenIds = this.threadLocalSeenIds.get();
            this.visitor = visitor;
            int numSpawnedThreads = Integer.max(1, numThreads - 1);
            this.executor = new ThreadPoolExecutor(numSpawnedThreads, numSpawnedThreads, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(numSpawnedThreads * 2), (ThreadFactory)new NamedThreadFactory("GBPTreeConsistencyChecker"), new ThreadPoolExecutor.CallerRunsPolicy());
            this.progress = progressMonitorFactory.singlePart("Check GBPTree consistency", this.lastId);
            FreelistSeenIdsVisitor freelistSeenIdsVisitor = new FreelistSeenIdsVisitor(file, this.mainSeenIds, this.lastId, visitor, this.progress);
            idProvider.visitFreelist(freelistSeenIdsVisitor, cursorCreator);
        }

        BitSet threadLocalSeenIds() {
            return this.threadLocalSeenIds.get();
        }

        private long highId() {
            return this.lastId + 1L;
        }

        @Override
        public void close() throws IOException {
            this.shutdownExecutor();
            for (BitSet threadLocalSeenIds : this.allThreadLocalSeenIds) {
                if (threadLocalSeenIds == this.mainSeenIds) continue;
                threadLocalSeenIds.stream().forEach(id -> GBPTreeConsistencyChecker.addToSeenList(this.file, this.mainSeenIds, id, this.lastId, this.visitor));
            }
            long highId = this.highId();
            for (int index = 3; index >= 0 && (long)index < highId; ++index) {
                if ((index = this.mainSeenIds.nextClearBit(index)) == -1 || (long)index >= highId) continue;
                this.visitor.unusedPage(index, this.file);
            }
            this.progress.close();
        }

        private void shutdownExecutor() {
            this.executor.shutdown();
            try {
                if (!this.executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                    this.executor.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                this.executor.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    private static class RightmostInChainShard {
        private final List<RightmostInChain> rightmostPerLevel = new ArrayList<RightmostInChain>();
        private final Path file;
        private final boolean leftmostShard;

        RightmostInChainShard(Path file, boolean leftmostShard) {
            this.file = file;
            this.leftmostShard = leftmostShard;
        }

        private RightmostInChain forLevel(int level) {
            for (int i = this.rightmostPerLevel.size(); i <= level; ++i) {
                this.rightmostPerLevel.add(i, new RightmostInChain(this.file, this.leftmostShard));
            }
            return this.rightmostPerLevel.get(level);
        }

        private void assertLast(GBPTreeConsistencyCheckVisitor visitor) {
            this.rightmostPerLevel.forEach(rightmost -> rightmost.assertLast(visitor));
        }

        private void assertAndMergeNext(RightmostInChainShard shard, GBPTreeConsistencyCheckVisitor visitor) {
            for (int j = 0; j < shard.rightmostPerLevel.size() || j < this.rightmostPerLevel.size(); ++j) {
                RightmostInChain right;
                RightmostInChain left = j < this.rightmostPerLevel.size() ? this.rightmostPerLevel.get(j) : null;
                RightmostInChain rightmostInChain = right = j < shard.rightmostPerLevel.size() ? shard.rightmostPerLevel.get(j) : null;
                if (left != null && right != null) {
                    left.assertNext(right, visitor);
                }
                if (right == null) continue;
                if (j >= this.rightmostPerLevel.size()) {
                    this.rightmostPerLevel.add(right);
                    continue;
                }
                this.rightmostPerLevel.set(j, right);
            }
        }
    }

    @FunctionalInterface
    static interface Monitor {
        public void dataKeysSeen(int var1);
    }

    static interface ChildVisitor<KEY> {
        public void accept(int var1, long var2, long var4, KeyRange<KEY> var6) throws IOException;
    }

    private static class DelayedVisitor
    extends GBPTreeConsistencyCheckVisitor.Adaptor {
        private final Path path;
        MutableLongList keysOutOfOrder = LongLists.mutable.empty();
        MutableList<KeyInWrongNode> keysLocatedInWrongNode = Lists.mutable.empty();

        DelayedVisitor(Path path) {
            this.path = path;
        }

        @Override
        public void keysOutOfOrderInNode(long pageId, Path file) {
            this.keysOutOfOrder.add(pageId);
        }

        @Override
        public void keysLocatedInWrongNode(KeyRange<?> range, Object key, int pos, int keyCount, long pageId, Path file) {
            this.keysLocatedInWrongNode.add((Object)new KeyInWrongNode(pageId, range, key, pos, keyCount));
        }

        void clear() {
            this.keysOutOfOrder.clear();
            this.keysLocatedInWrongNode.clear();
        }

        void report(GBPTreeConsistencyCheckVisitor visitor) {
            if (this.keysOutOfOrder.notEmpty()) {
                this.keysOutOfOrder.forEach((LongProcedure & Serializable)pageId -> visitor.keysOutOfOrderInNode(pageId, this.path));
            }
            if (this.keysLocatedInWrongNode.notEmpty()) {
                this.keysLocatedInWrongNode.forEach((Procedure & Serializable)keyInWrongNode -> visitor.keysLocatedInWrongNode(keyInWrongNode.range, keyInWrongNode.key, keyInWrongNode.pos, keyInWrongNode.keyCount, keyInWrongNode.pageId, this.path));
            }
        }

        private record KeyInWrongNode(long pageId, KeyRange<?> range, Object key, int pos, int keyCount) {
        }
    }

    private static class FreelistSeenIdsVisitor
    implements IdProvider.IdProviderVisitor {
        private final Path path;
        private final BitSet seenIds;
        private final long lastId;
        private final GBPTreeConsistencyCheckVisitor visitor;
        private final ProgressListener progress;

        private FreelistSeenIdsVisitor(Path path, BitSet seenIds, long lastId, GBPTreeConsistencyCheckVisitor visitor, ProgressListener progress) {
            this.path = path;
            this.seenIds = seenIds;
            this.lastId = lastId;
            this.visitor = visitor;
            this.progress = progress;
        }

        @Override
        public void beginFreelistPage(long pageId) {
            GBPTreeConsistencyChecker.addToSeenList(this.path, this.seenIds, pageId, this.lastId, this.visitor);
            this.progress.add(1L);
        }

        @Override
        public void endFreelistPage(long pageId) {
        }

        @Override
        public void freelistEntry(long pageId, long generation, int pos) {
            GBPTreeConsistencyChecker.addToSeenList(this.path, this.seenIds, pageId, this.lastId, this.visitor);
        }

        @Override
        public void freelistEntryFromReleaseCache(long pageId) {
            GBPTreeConsistencyChecker.addToSeenList(this.path, this.seenIds, pageId, this.lastId, this.visitor);
        }
    }
}

