/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import org.neo4j.common.DependencyResolver;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.OffloadStore;
import org.neo4j.index.internal.gbptree.TreeNode;
import org.neo4j.index.internal.gbptree.TreeNodeDynamicSize;
import org.neo4j.index.internal.gbptree.TreeNodeFixedSize;
import org.neo4j.index.internal.gbptree.TreeNodeSelector;

public class DefaultTreeNodeSelector {
    private static final TreeNodeSelector.Factory FIXED = new TreeNodeSelector.Factory(){

        @Override
        public <KEY, VALUE> TreeNode<KEY, VALUE> create(int pageSize, Layout<KEY, VALUE> layout, OffloadStore<KEY, VALUE> offloadStore, DependencyResolver dependencyResolver) {
            return new TreeNodeFixedSize<KEY, VALUE>(pageSize, layout);
        }

        @Override
        public byte formatIdentifier() {
            return 2;
        }

        @Override
        public byte formatVersion() {
            return 0;
        }
    };
    private static final TreeNodeSelector.Factory DYNAMIC = new TreeNodeSelector.Factory(){

        @Override
        public <KEY, VALUE> TreeNode<KEY, VALUE> create(int payloadSize, Layout<KEY, VALUE> layout, OffloadStore<KEY, VALUE> offloadStore, DependencyResolver dependencyResolver) {
            return new TreeNodeDynamicSize<KEY, VALUE>(payloadSize, layout, offloadStore);
        }

        @Override
        public byte formatIdentifier() {
            return 3;
        }

        @Override
        public byte formatVersion() {
            return 0;
        }
    };

    public static TreeNodeSelector selector() {
        return layout -> layout.fixedSize() ? FIXED : DYNAMIC;
    }
}

