/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.nio.file.Path;
import java.util.StringJoiner;
import org.neo4j.index.internal.gbptree.CleanupJob;
import org.neo4j.index.internal.gbptree.CrashGenerationCleaner;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.GBPTreeLock;

class GBPTreeCleanupJob
implements CleanupJob {
    private final CrashGenerationCleaner crashGenerationCleaner;
    private final GBPTreeLock gbpTreeLock;
    private final GBPTree.Monitor monitor;
    private final Path indexFile;
    private volatile boolean needed;
    private volatile Throwable failure;

    GBPTreeCleanupJob(CrashGenerationCleaner crashGenerationCleaner, GBPTreeLock gbpTreeLock, GBPTree.Monitor monitor, Path indexFile) {
        this.crashGenerationCleaner = crashGenerationCleaner;
        this.gbpTreeLock = gbpTreeLock;
        this.monitor = monitor;
        this.indexFile = indexFile;
        this.needed = true;
    }

    @Override
    public boolean needed() {
        return this.needed;
    }

    @Override
    public boolean hasFailed() {
        return this.failure != null;
    }

    @Override
    public Throwable getCause() {
        return this.failure;
    }

    @Override
    public void close() {
        this.gbpTreeLock.cleanerUnlock();
        this.monitor.cleanupClosed();
    }

    @Override
    public void run(CleanupJob.Executor executor) {
        try {
            this.crashGenerationCleaner.clean(executor);
            this.needed = false;
        }
        catch (Throwable e) {
            this.monitor.cleanupFailed(e);
            this.failure = e;
        }
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", "CleanupJob(", ")");
        joiner.add("file=" + String.valueOf(this.indexFile.toAbsolutePath()));
        joiner.add("needed=" + this.needed);
        joiner.add("failure=" + String.valueOf(this.failure));
        return joiner.toString();
    }
}

