/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import org.neo4j.index.internal.gbptree.GenerationSafePointer;

class Generation {
    private static final long UNSTABLE_GENERATION_MASK = 0xFFFFFFFFL;
    private static final int STABLE_GENERATION_SHIFT = 32;

    Generation() {
    }

    public static long generation(long stableGeneration, long unstableGeneration) {
        GenerationSafePointer.assertGenerationOnWrite(stableGeneration);
        GenerationSafePointer.assertGenerationOnWrite(unstableGeneration);
        return stableGeneration << 32 | unstableGeneration;
    }

    public static long unstableGeneration(long generation) {
        return generation & 0xFFFFFFFFL;
    }

    public static long stableGeneration(long generation) {
        return generation >>> 32;
    }
}

