/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.function.LongConsumer;
import org.neo4j.internal.helpers.VarHandleUtils;

class LongSpinLatch {
    private static final int SPIN_THRESHOLD = Runtime.getRuntime().availableProcessors() < 2 ? 1 : 1000;
    private static final int SHORT_PARK_THRESHOLD = 100000;
    private static final int LONG_PARK_COUNTER = 100001;
    private static final int SHORT_PARK_TIME = 10;
    private static final long LONG_PARK_TIME = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final long WRITE_LOCK_MASK = 32768L;
    private static final long READ_LOCK_MASK = 32767L;
    private static final long LOCK_MASK = 65535L;
    private static final long REF_COUNT_MASK = 0x7FFF0000L;
    private static final long REF_COUNT_UNIT = 65536L;
    private static final long DEAD_MASK = 0x80000000L;
    private final long initialTreeNodeId;
    private final LongConsumer removeAction;
    private volatile long lockBits;
    private static final VarHandle LOCK_BITS = VarHandleUtils.getVarHandle((MethodHandles.Lookup)MethodHandles.lookup(), (String)"lockBits");

    LongSpinLatch(long initialTreeNodeId, LongConsumer removeAction) {
        this.initialTreeNodeId = initialTreeNodeId;
        this.removeAction = removeAction;
    }

    boolean ref() {
        long prevBits;
        do {
            if (LongSpinLatch.isAlive(prevBits = this.getAcquireBits()) && (prevBits & 0x7FFF0000L) != 0x7FFF0000L) continue;
            return false;
        } while (!LOCK_BITS.weakCompareAndSetRelease(this, prevBits, prevBits + 65536L));
        return true;
    }

    void deref() {
        boolean lastRef;
        long bits;
        long prevBits;
        while (true) {
            prevBits = this.getAcquireBits();
            LongSpinLatch.assertAlive(prevBits);
            bits = prevBits - 65536L;
            if ((bits & 0x7FFF0000L) == 0L) {
                bits |= 0x80000000L;
            }
            if (LOCK_BITS.weakCompareAndSetRelease(this, prevBits, bits)) break;
            Thread.onSpinWait();
        }
        boolean bl = lastRef = LongSpinLatch.isAlive(prevBits) && !LongSpinLatch.isAlive(bits);
        if (lastRef) {
            this.removeAction.accept(this.initialTreeNodeId);
        }
        if ((prevBits & 0x7FFF0000L) == 0L) {
            throw new IllegalStateException("Called 'deref()' on a latch without a matching 'ref()'");
        }
    }

    long acquireRead() {
        long parkTime = 0L;
        while (true) {
            long prevBits = this.getAcquireBits();
            LongSpinLatch.assertAlive(prevBits);
            if ((prevBits & 0x7FFFL) == 32767L) {
                throw new IllegalStateException("Too many readers");
            }
            if (LongSpinLatch.hasWriter(prevBits)) {
                parkTime = LongSpinLatch.exponentialPark(parkTime);
                continue;
            }
            if (LOCK_BITS.weakCompareAndSetRelease(this, prevBits, prevBits + 1L)) {
                return (prevBits & 0x7FFFL) + 1L;
            }
            Thread.onSpinWait();
        }
    }

    long releaseRead() {
        long prevBits = LOCK_BITS.getAndAdd(this, -1L);
        LongSpinLatch.assertAlive(prevBits);
        if (!LongSpinLatch.hasReaders(prevBits)) {
            throw new IllegalStateException("Called 'releaseRead()' on a latch without a reader");
        }
        return (prevBits & 0x7FFFL) - 1L;
    }

    boolean tryUpgradeToWrite() {
        long bits = this.getAcquireBits();
        LongSpinLatch.assertAlive(bits);
        if ((bits & 0xFFFFL) == 1L) {
            return LOCK_BITS.compareAndSet(this, bits, bits & 0xFFFFFFFFFFFF0000L | 0x8000L);
        }
        return false;
    }

    void acquireWrite() {
        long prevBits;
        long parkTime = 0L;
        while (true) {
            prevBits = LOCK_BITS.getAndBitwiseOr(this, 32768L);
            LongSpinLatch.assertAlive(prevBits);
            if (!LongSpinLatch.hasWriter(prevBits)) break;
            parkTime = LongSpinLatch.exponentialPark(parkTime);
        }
        parkTime = 0L;
        while (LongSpinLatch.hasReaders(prevBits)) {
            parkTime = LongSpinLatch.exponentialPark(parkTime);
            prevBits = this.getAcquireBits();
        }
    }

    boolean tryAcquireWrite() {
        long prevBits = this.getAcquireBits();
        LongSpinLatch.assertAlive(prevBits);
        if (!LongSpinLatch.hasReaders(prevBits) && !LongSpinLatch.hasWriter(prevBits)) {
            return LOCK_BITS.compareAndSet(this, prevBits, prevBits | 0x8000L);
        }
        return false;
    }

    void releaseWrite() {
        long prevBits = LOCK_BITS.getAndBitwiseAndRelease(this, -32769L);
        LongSpinLatch.assertAlive(prevBits);
        if (!LongSpinLatch.hasWriter(prevBits)) {
            throw new IllegalStateException("Expected latch to be write locked. Got " + prevBits);
        }
    }

    private static boolean isAlive(long bits) {
        return (bits & 0x80000000L) == 0L;
    }

    private static void assertAlive(long bits) {
        if (!LongSpinLatch.isAlive(bits)) {
            throw new IllegalStateException("Latch is dead");
        }
    }

    private static boolean hasReaders(long bits) {
        return (bits & 0x7FFFL) != 0L;
    }

    private static boolean hasWriter(long bits) {
        return (bits & 0x8000L) != 0L;
    }

    long treeNodeId() {
        return this.initialTreeNodeId;
    }

    private long getAcquireBits() {
        return LOCK_BITS.getAcquire(this);
    }

    private long volatileGetBits() {
        return LOCK_BITS.getVolatile(this);
    }

    public static long exponentialPark(long idleCounter) {
        if (idleCounter < (long)SPIN_THRESHOLD) {
            Thread.onSpinWait();
        } else if (idleCounter < 100000L) {
            LockSupport.parkNanos(10L);
        } else {
            LockSupport.parkNanos(LONG_PARK_TIME);
            return 100001L;
        }
        return idleCounter + 1L;
    }

    public String toString() {
        long bits = this.volatileGetBits();
        return String.format("Lock[%d,w:%b,r:%d,refs:%d]", this.initialTreeNodeId, (bits & 0x8000L) != 0L, bits & 0x7FFFL, (bits & 0x7FFF0000L) >> 16);
    }
}

