/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.util.Comparator;
import org.neo4j.index.internal.gbptree.Layout;

class KeyRange<KEY> {
    private final int level;
    private final long pageId;
    private final Comparator<KEY> comparator;
    private final KEY fromInclusive;
    private final KEY toExclusive;
    private final Layout<KEY, ?> layout;
    private final KeyRange<KEY> superRange;

    KeyRange(int level, long pageId, Comparator<KEY> comparator, KEY fromInclusive, KEY toExclusive, Layout<KEY, ?> layout, KeyRange<KEY> superRange) {
        this.level = level;
        this.pageId = pageId;
        this.comparator = comparator;
        this.superRange = superRange;
        this.fromInclusive = fromInclusive == null ? null : layout.copyKey(fromInclusive, layout.newKey());
        this.toExclusive = toExclusive == null ? null : layout.copyKey(toExclusive, layout.newKey());
        this.layout = layout;
    }

    boolean inRange(KEY key) {
        if (this.fromInclusive != null) {
            if (this.toExclusive != null) {
                return this.comparator.compare(key, this.fromInclusive) >= 0 && this.comparator.compare(key, this.toExclusive) < 0;
            }
            return this.comparator.compare(key, this.fromInclusive) >= 0;
        }
        return this.toExclusive == null || this.comparator.compare(key, this.toExclusive) < 0;
    }

    KeyRange<KEY> newSubRange(int level, long pageId) {
        return new KeyRange<KEY>(level, pageId, this.comparator, this.fromInclusive, this.toExclusive, this.layout, this);
    }

    boolean hasPageIdInStack(long pageId) {
        if (this.pageId == pageId) {
            return true;
        }
        if (this.superRange != null) {
            return this.superRange.hasPageIdInStack(pageId);
        }
        return false;
    }

    KeyRange<KEY> restrictLeft(KEY left) {
        KEY newLeft = this.fromInclusive == null ? left : (left == null ? this.fromInclusive : (this.comparator.compare(this.fromInclusive, left) < 0 ? left : this.fromInclusive));
        return new KeyRange<KEY>(this.level, this.pageId, this.comparator, newLeft, this.toExclusive, this.layout, this.superRange);
    }

    KeyRange<KEY> restrictRight(KEY right) {
        KEY newRight = this.toExclusive == null ? right : (right == null ? this.toExclusive : (this.comparator.compare(this.toExclusive, right) > 0 ? right : this.toExclusive));
        return new KeyRange<KEY>(this.level, this.pageId, this.comparator, this.fromInclusive, newRight, this.layout, this.superRange);
    }

    public String toString() {
        return (this.superRange != null ? String.format("%s%n", this.superRange) : "") + this.singleLevel();
    }

    private String singleLevel() {
        return "level: " + this.level + " {" + this.pageId + "} " + String.valueOf(this.fromInclusive) + " \u2264 key < " + String.valueOf(this.toExclusive);
    }
}

