/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache;

import org.neo4j.internal.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.io.ByteUnit;

public class GatheringMemoryStatsVisitor
implements MemoryStatsVisitor {
    private long heapUsage;
    private long offHeapUsage;

    @Override
    public void heapUsage(long bytes) {
        this.heapUsage += bytes;
    }

    @Override
    public void offHeapUsage(long bytes) {
        this.offHeapUsage += bytes;
    }

    public long getHeapUsage() {
        return this.heapUsage;
    }

    public long getOffHeapUsage() {
        return this.offHeapUsage;
    }

    public long getTotalUsage() {
        return this.heapUsage + this.offHeapUsage;
    }

    public String toString() {
        return "Memory usage[heap:" + ByteUnit.bytesToString((long)this.heapUsage) + ", off-heap:" + ByteUnit.bytesToString((long)this.offHeapUsage) + "]";
    }

    public static long totalMemoryUsageOf(MemoryStatsVisitor.Visitable ... memoryUsers) {
        GatheringMemoryStatsVisitor memoryVisitor = new GatheringMemoryStatsVisitor();
        for (MemoryStatsVisitor.Visitable memoryUser : memoryUsers) {
            memoryUser.acceptMemoryStatsVisitor(memoryVisitor);
        }
        return memoryVisitor.getTotalUsage();
    }

    public static long highestMemoryUsageOf(MemoryStatsVisitor.Visitable ... memoryUsers) {
        long max = 0L;
        for (MemoryStatsVisitor.Visitable visitable : memoryUsers) {
            max = Long.max(max, GatheringMemoryStatsVisitor.totalMemoryUsageOf(visitable));
        }
        return max;
    }
}

