/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id;

import java.io.Closeable;
import java.io.IOException;
import org.neo4j.annotations.documented.ReporterFactory;
import org.neo4j.collection.PrimitiveLongResourceCollections;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.internal.id.FreeIds;
import org.neo4j.internal.id.IdSequence;
import org.neo4j.internal.id.IdType;
import org.neo4j.internal.id.range.PageIdRange;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;
import org.neo4j.kernel.impl.index.schema.ConsistencyCheckable;

public interface IdGenerator
extends IdSequence,
Closeable,
ConsistencyCheckable {
    public static final NoOpMarker NOOP_MARKER = new NoOpMarker(){};

    @Override
    public long nextId(CursorContext var1);

    public long nextConsecutiveIdRange(int var1, boolean var2, CursorContext var3);

    public PageIdRange nextPageRange(CursorContext var1, int var2);

    public void releasePageRange(PageIdRange var1, CursorContext var2);

    public void setHighId(long var1);

    default public void setHighestPossibleIdInUse(long highestInUse) {
        this.setHighId(highestInUse + 1L);
    }

    public void markHighestWrittenAtHighId();

    public long getHighestWritten();

    public long getHighId();

    public long getHighestPossibleIdInUse();

    public long getUnusedIdCount() throws IOException;

    public TransactionalMarker transactionalMarker(CursorContext var1);

    public ContextualMarker contextualMarker(CursorContext var1);

    @Override
    public void close();

    public void checkpoint(FileFlushEvent var1, CursorContext var2);

    public void maintenance(CursorContext var1);

    public void start(FreeIds var1, CursorContext var2) throws IOException;

    public void clearCache(boolean var1, CursorContext var2);

    public boolean allocationEnabled();

    public IdType idType();

    public boolean hasOnlySingleIds();

    default public PrimitiveLongResourceIterator notUsedIdsIterator() throws IOException {
        return PrimitiveLongResourceCollections.emptyIterator();
    }

    default public PrimitiveLongResourceIterator notUsedIdsIterator(long fromIdInclusive, long toIdExclusive) throws IOException {
        return PrimitiveLongResourceCollections.emptyIterator();
    }

    default public PrimitiveLongResourceIterator freeIdsIterator() throws IOException {
        return PrimitiveLongResourceCollections.emptyIterator();
    }

    public static class NoOpMarker
    implements TransactionalMarker,
    ContextualMarker {
        @Override
        public void markFree(long id, int numberOfIds) {
        }

        @Override
        public void markUsed(long id, int numberOfIds) {
        }

        @Override
        public void markDeleted(long id, int numberOfIds) {
        }

        @Override
        public void markDeletedAndFree(long id, int numberOfIds) {
        }

        @Override
        public void markUnallocated(long id, int numberOfIds) {
        }

        @Override
        public void markUnreserved(long id, int numberOfIds) {
        }

        @Override
        public void markReserved(long id, int numberOfIds) {
        }

        @Override
        public void markUncached(long id, int numberOfIds) {
        }

        @Override
        public void close() {
        }
    }

    public static class Delegate
    implements IdGenerator {
        protected final IdGenerator delegate;

        public Delegate(IdGenerator delegate) {
            this.delegate = delegate;
        }

        @Override
        public long nextId(CursorContext cursorContext) {
            return this.delegate.nextId(cursorContext);
        }

        @Override
        public long nextConsecutiveIdRange(int numberOfIds, boolean favorSamePage, CursorContext cursorContext) {
            return this.delegate.nextConsecutiveIdRange(numberOfIds, favorSamePage, cursorContext);
        }

        @Override
        public PageIdRange nextPageRange(CursorContext cursorContext, int idsPerPage) {
            return this.delegate.nextPageRange(cursorContext, idsPerPage);
        }

        @Override
        public void releasePageRange(PageIdRange range, CursorContext cursorContext) {
            this.delegate.releasePageRange(range, cursorContext);
        }

        @Override
        public void setHighId(long id) {
            this.delegate.setHighId(id);
        }

        @Override
        public void markHighestWrittenAtHighId() {
            this.delegate.markHighestWrittenAtHighId();
        }

        @Override
        public long getHighestWritten() {
            return this.delegate.getHighestWritten();
        }

        @Override
        public long getHighId() {
            return this.delegate.getHighId();
        }

        @Override
        public long getHighestPossibleIdInUse() {
            return this.delegate.getHighestPossibleIdInUse();
        }

        @Override
        public long getUnusedIdCount() throws IOException {
            return this.delegate.getUnusedIdCount();
        }

        @Override
        public TransactionalMarker transactionalMarker(CursorContext cursorContext) {
            return this.delegate.transactionalMarker(cursorContext);
        }

        @Override
        public ContextualMarker contextualMarker(CursorContext cursorContext) {
            return this.delegate.contextualMarker(cursorContext);
        }

        @Override
        public void close() {
            this.delegate.close();
        }

        @Override
        public void checkpoint(FileFlushEvent fileFlushEvent, CursorContext cursorContext) {
            this.delegate.checkpoint(fileFlushEvent, cursorContext);
        }

        @Override
        public void maintenance(CursorContext cursorContext) {
            this.delegate.maintenance(cursorContext);
        }

        @Override
        public void start(FreeIds freeIdsForRebuild, CursorContext cursorContext) throws IOException {
            this.delegate.start(freeIdsForRebuild, cursorContext);
        }

        @Override
        public void clearCache(boolean allocationEnabled, CursorContext cursorContext) {
            this.delegate.clearCache(allocationEnabled, cursorContext);
        }

        @Override
        public boolean allocationEnabled() {
            return this.delegate.allocationEnabled();
        }

        @Override
        public IdType idType() {
            return this.delegate.idType();
        }

        @Override
        public boolean hasOnlySingleIds() {
            return this.delegate.hasOnlySingleIds();
        }

        @Override
        public PrimitiveLongResourceIterator notUsedIdsIterator() throws IOException {
            return this.delegate.notUsedIdsIterator();
        }

        @Override
        public PrimitiveLongResourceIterator notUsedIdsIterator(long fromIdInclusive, long toIdExclusive) throws IOException {
            return this.delegate.notUsedIdsIterator(fromIdInclusive, toIdExclusive);
        }

        public boolean consistencyCheck(ReporterFactory reporterFactory, CursorContextFactory contextFactory, int numThreads, ProgressMonitorFactory progressMonitorFactory) {
            return this.delegate.consistencyCheck(reporterFactory, contextFactory, numThreads, progressMonitorFactory);
        }
    }

    public static interface ContextualMarker
    extends AutoCloseable {
        default public void markFree(long id) {
            this.markFree(id, 1);
        }

        public void markFree(long var1, int var3);

        default public void markReserved(long id) {
            this.markReserved(id, 1);
        }

        default public void markUnreserved(long id) {
            this.markUnreserved(id, 1);
        }

        public void markReserved(long var1, int var3);

        public void markUnreserved(long var1, int var3);

        public void markUncached(long var1, int var3);

        @Override
        public void close();

        public static class Delegate
        implements ContextualMarker {
            private final ContextualMarker actual;

            public Delegate(ContextualMarker actual) {
                this.actual = actual;
            }

            @Override
            public void markFree(long id, int numberOfIds) {
                this.actual.markFree(id, numberOfIds);
            }

            @Override
            public void markReserved(long id, int numberOfIds) {
                this.actual.markReserved(id, numberOfIds);
            }

            @Override
            public void markUnreserved(long id, int numberOfIds) {
                this.actual.markUnreserved(id, numberOfIds);
            }

            @Override
            public void markUncached(long id, int numberOfIds) {
                this.actual.markUncached(id, numberOfIds);
            }

            @Override
            public void close() {
                this.actual.close();
            }
        }
    }

    public static interface TransactionalMarker
    extends AutoCloseable {
        default public void markUsed(long id) {
            this.markUsed(id, 1);
        }

        public void markUsed(long var1, int var3);

        default public void markDeleted(long id) {
            this.markDeleted(id, 1);
        }

        public void markDeleted(long var1, int var3);

        default public void markDeletedAndFree(long id) {
            this.markDeletedAndFree(id, 1);
        }

        public void markDeletedAndFree(long var1, int var3);

        default public void markUnallocated(long id) {
            this.markUnallocated(id, 1);
        }

        public void markUnallocated(long var1, int var3);

        @Override
        public void close();

        public static class Delegate
        implements TransactionalMarker {
            protected final TransactionalMarker actual;

            public Delegate(TransactionalMarker actual) {
                this.actual = actual;
            }

            @Override
            public void markUsed(long id, int numberOfIds) {
                this.actual.markUsed(id, numberOfIds);
            }

            @Override
            public void markDeleted(long id, int numberOfIds) {
                this.actual.markDeleted(id, numberOfIds);
            }

            @Override
            public void markDeletedAndFree(long id, int numberOfIds) {
                this.actual.markDeletedAndFree(id, numberOfIds);
            }

            @Override
            public void markUnallocated(long id, int numberOfIds) {
                this.actual.markUnallocated(id, numberOfIds);
            }

            @Override
            public void close() {
                this.actual.close();
            }
        }
    }
}

