/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id.indexed;

import java.util.function.Consumer;
import java.util.function.LongSupplier;
import org.neo4j.io.pagecache.PageCursor;

class HeaderWriter
implements Consumer<PageCursor> {
    private final LongSupplier highId;
    private final LongSupplier highestWrittenId;
    private final long generation;
    private final int idsPerEntry;

    HeaderWriter(LongSupplier highId, LongSupplier highestWrittenId, long generation, int idsPerEntry) {
        this.highId = highId;
        this.highestWrittenId = highestWrittenId;
        this.generation = generation;
        this.idsPerEntry = idsPerEntry;
    }

    @Override
    public void accept(PageCursor cursor) {
        long highId = this.highId.getAsLong();
        long highestWrittenId = this.highestWrittenId.getAsLong();
        cursor.putLong(highId);
        cursor.putLong(highestWrittenId);
        cursor.putLong(this.generation);
        cursor.putInt(this.idsPerEntry);
    }
}

