/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id;

public class IdUtils {
    private static final long MASK_USED = Long.MIN_VALUE;
    private static final int NUM_BITS_NUMBER_OF_IDS = 8;
    private static final int SHIFT_NUMBER_OF_IDS = 55;
    private static final long MASK_NUMBER_OF_IDS = 9187343239835811840L;
    private static final long MASK_ID = 0x7FFFFFFFFFFFFFL;
    static final long MAX_ID = 0x7FFFFFFFFFFFFFL;
    static final int MAX_NUMBER_OF_IDS = 256;

    public static long combinedIdAndNumberOfIds(long id, int numberOfIds, boolean used) {
        int storedNumberOfIds = numberOfIds - 1;
        if ((id & 0xFF80000000000000L) != 0L) {
            throw new IllegalArgumentException("ID " + id + " is too big");
        }
        if (storedNumberOfIds > 255) {
            throw new IllegalArgumentException("Number of IDs " + numberOfIds + " is too big");
        }
        return id | (long)storedNumberOfIds << 55 | (used ? Long.MIN_VALUE : 0L);
    }

    public static long idFromCombinedId(long combinedId) {
        return combinedId & 0x7FFFFFFFFFFFFFL;
    }

    public static int numberOfIdsFromCombinedId(long combinedId) {
        return (int)((combinedId & 0x7F80000000000000L) >>> 55) + 1;
    }

    public static boolean usedFromCombinedId(long combined) {
        return (combined & Long.MIN_VALUE) != 0L;
    }
}

