/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id.indexed;

import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.index.internal.gbptree.ValueMerger;
import org.neo4j.internal.id.indexed.IdRange;
import org.neo4j.internal.id.indexed.IdRangeKey;
import org.neo4j.internal.id.indexed.IndexedIdGenerator;

final class IdRangeMerger
implements ValueMerger<IdRangeKey, IdRange> {
    private final boolean recoveryMode;
    private final IndexedIdGenerator.Monitor monitor;
    private final AtomicLong numUnusedIds;
    private int diffNumUnusedIds;

    IdRangeMerger(boolean recoveryMode, IndexedIdGenerator.Monitor monitor, AtomicLong numUnusedIds) {
        this.recoveryMode = recoveryMode;
        this.monitor = monitor;
        this.numUnusedIds = numUnusedIds;
    }

    public ValueMerger.MergeResult merge(IdRangeKey existingKey, IdRangeKey newKey, IdRange existingValue, IdRange newValue) {
        if (!this.recoveryMode && existingValue.getGeneration() != newValue.getGeneration()) {
            existingValue.normalize();
            existingValue.setGeneration(newValue.getGeneration());
            this.monitor.normalized(existingKey.getIdRangeIdx());
        }
        this.diffNumUnusedIds = existingValue.mergeFrom(existingKey, newValue, this.recoveryMode);
        return existingValue.isEmpty() ? ValueMerger.MergeResult.REMOVED : ValueMerger.MergeResult.MERGED;
    }

    public void added(IdRangeKey newKey, IdRange newValue) {
        this.diffNumUnusedIds = newValue.numUnusedIdsForAdded();
    }

    public void completed() {
        if (this.diffNumUnusedIds != 0) {
            if (this.numUnusedIds != null) {
                this.numUnusedIds.addAndGet(this.diffNumUnusedIds);
            }
            this.diffNumUnusedIds = 0;
        }
    }
}

