/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster.modeswitch;

import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.kernel.ha.DelegateInvocationHandler;
import org.neo4j.kernel.ha.MasterTransactionCommitProcess;
import org.neo4j.kernel.ha.SlaveTransactionCommitProcess;
import org.neo4j.kernel.ha.cluster.modeswitch.AbstractComponentSwitcher;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.transaction.TransactionPropagator;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionRepresentationCommitProcess;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.state.IntegrityValidator;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.storageengine.api.StorageEngine;

public class CommitProcessSwitcher
extends AbstractComponentSwitcher<TransactionCommitProcess> {
    private final TransactionPropagator txPropagator;
    private final Master master;
    private final RequestContextFactory requestContextFactory;
    private final DependencyResolver dependencyResolver;
    private final MasterTransactionCommitProcess.Monitor monitor;
    private final Locks locks;
    private final boolean reacquireSharedSchemaLockOnIncomingTransactions;

    public CommitProcessSwitcher(TransactionPropagator txPropagator, Master master, DelegateInvocationHandler<TransactionCommitProcess> delegate, RequestContextFactory requestContextFactory, Locks locks, Monitors monitors, DependencyResolver dependencyResolver, boolean reacquireSharedSchemaLockOnIncomingTransactions) {
        super(delegate);
        this.txPropagator = txPropagator;
        this.master = master;
        this.requestContextFactory = requestContextFactory;
        this.locks = locks;
        this.dependencyResolver = dependencyResolver;
        this.reacquireSharedSchemaLockOnIncomingTransactions = reacquireSharedSchemaLockOnIncomingTransactions;
        this.monitor = (MasterTransactionCommitProcess.Monitor)monitors.newMonitor(MasterTransactionCommitProcess.Monitor.class, new String[0]);
    }

    @Override
    protected TransactionCommitProcess getSlaveImpl() {
        return new SlaveTransactionCommitProcess(this.master, this.requestContextFactory);
    }

    @Override
    protected TransactionCommitProcess getMasterImpl() {
        TransactionRepresentationCommitProcess commitProcess = new TransactionRepresentationCommitProcess((TransactionAppender)this.dependencyResolver.resolveDependency(TransactionAppender.class), (StorageEngine)this.dependencyResolver.resolveDependency(StorageEngine.class));
        IntegrityValidator validator = (IntegrityValidator)this.dependencyResolver.resolveDependency(IntegrityValidator.class);
        return new MasterTransactionCommitProcess((TransactionCommitProcess)commitProcess, this.txPropagator, validator, this.monitor, this.locks, this.reacquireSharedSchemaLockOnIncomingTransactions);
    }
}

