/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.api;

import org.neo4j.dbms.api.DatabaseExistsException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.gqlstatus.PrivilegeGqlCodeEntity;

public class DatabaseExistsHelper {
    public static DatabaseExistsException failedCreateAliasBecauseDatabaseExists(String databaseName) {
        ErrorGqlStatusObject gql = PrivilegeGqlCodeEntity.entityAlreadyExists((PrivilegeGqlCodeEntity)PrivilegeGqlCodeEntity.DATABASE, (String)databaseName);
        return new DatabaseExistsException(gql, "Failed to create the specified database alias '%s': Database exists with that name.".formatted(databaseName));
    }

    public static DatabaseExistsException failedCreateAliasBecauseAliasExists(String databaseName) {
        ErrorGqlStatusObject gql = PrivilegeGqlCodeEntity.entityAlreadyExists((PrivilegeGqlCodeEntity)PrivilegeGqlCodeEntity.DATABASE, (String)databaseName);
        return new DatabaseExistsException(gql, "Failed to create the specified database alias '%s': Database name or alias already exists.".formatted(databaseName));
    }

    public static DatabaseExistsException failedCreateDatabaseBecauseDatabaseExists(String name, String otherName) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N87).withParam(GqlParams.StringParam.db1, name).withParam(GqlParams.StringParam.db2, otherName).build();
        return new DatabaseExistsException(gql, String.format("Cannot create database '%s' because another database '%s' exists with an ambiguous name.", name, otherName));
    }

    public static DatabaseExistsException failedCreateDatabaseBecauseAliasExists(String databaseName) {
        ErrorGqlStatusObject gql = PrivilegeGqlCodeEntity.entityAlreadyExists((PrivilegeGqlCodeEntity)PrivilegeGqlCodeEntity.DATABASE, (String)databaseName);
        return new DatabaseExistsException(gql, "Failed to create the specified database '%s': Database name or alias already exists.".formatted(databaseName));
    }

    public static DatabaseExistsException failedCreateDatabaseBecausePartAlreadyExists(String ownerDatabaseName, String databaseName) {
        ErrorGqlStatusObject gql = PrivilegeGqlCodeEntity.entityAlreadyExists((PrivilegeGqlCodeEntity)PrivilegeGqlCodeEntity.DATABASE, (String)databaseName);
        return new DatabaseExistsException(gql, "Failed to create the specified database '%s': Part of database '%s' name or alias already exists.".formatted(ownerDatabaseName, databaseName));
    }
}

