/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.frontend.phases;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.neo4j.cypher.internal.ast.semantics.SemanticError;
import org.neo4j.cypher.internal.ast.semantics.SemanticTable;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.FunctionInvocation;
import org.neo4j.cypher.internal.expressions.FunctionName;
import org.neo4j.cypher.internal.expressions.PatternExpression;
import org.neo4j.cypher.internal.expressions.functions.Exists$;
import org.neo4j.cypher.internal.frontend.phases.BaseContext;
import org.neo4j.cypher.internal.frontend.phases.BaseState;
import org.neo4j.cypher.internal.frontend.phases.ExpectedBooleanTypeCheck;
import org.neo4j.cypher.internal.util.Foldable;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.LambdaDeserialize;

public final class PatternExpressionInNonExistenceCheck$
implements ExpectedBooleanTypeCheck {
    public static final PatternExpressionInNonExistenceCheck$ MODULE$ = new PatternExpressionInNonExistenceCheck$();
    private static final String errorMessage;
    private static final String errorMessageForSizeFunction;

    static {
        ExpectedBooleanTypeCheck.$init$(MODULE$);
        errorMessage = "A pattern expression should only be used in order to test the existence of a pattern. It should therefore only be used in contexts that evaluate to a boolean, e.g. inside the function exists() or in a WHERE-clause. No other uses are allowed, instead they should be replaced by a pattern comprehension.";
        errorMessageForSizeFunction = "A pattern expression should only be used in order to test the existence of a pattern. It can no longer be used inside the function size(), an alternative is to replace size() with COUNT {}.";
    }

    @Override
    public boolean isExpectedTypeBoolean(SemanticTable semanticTable, Expression e) {
        return ExpectedBooleanTypeCheck.isExpectedTypeBoolean$(this, semanticTable, e);
    }

    public Function2<BaseState, BaseContext, Seq<SemanticError>> patternExpressionInNonExistenceCheck() {
        return (Function2 & Serializable)(baseState, x$3) -> (Seq)baseState.statement().folder().treeFold((Object)package$.MODULE$.Seq().empty(), (PartialFunction)new Serializable((BaseState)baseState){
            private static final long serialVersionUID = 0L;
            private final BaseState baseState$1;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Expression expression;
                Option option;
                A1 A1 = x1;
                if (A1 instanceof Expression && !(option = Exists$.MODULE$.unapply(expression = (Expression)A1)).isEmpty()) {
                    return (B1)(Function1 & Serializable)errors -> new Foldable.SkipChildren(errors);
                }
                if (A1 instanceof FunctionInvocation) {
                    String string;
                    FunctionInvocation functionInvocation = (FunctionInvocation)A1;
                    FunctionName functionName = functionInvocation.functionName();
                    IndexedSeq indexedSeq = functionInvocation.args();
                    if (functionName != null && "size".equals(string = functionName.name()) && indexedSeq instanceof Vector) {
                        Expression p;
                        Vector vector = (Vector)indexedSeq;
                        SeqOps seqOps = package$.MODULE$.Vector().unapplySeq((SeqOps)vector);
                        if (!SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (p = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof PatternExpression) {
                            PatternExpression patternExpression = (PatternExpression)p;
                            if (!PatternExpressionInNonExistenceCheck$.MODULE$.isExpectedTypeBoolean(this.baseState$1.semanticTable(), (Expression)patternExpression)) {
                                return (B1)(Function1 & Serializable)errors -> new Foldable.SkipChildren(errors.$colon$plus((Object)new SemanticError(PatternExpressionInNonExistenceCheck$.MODULE$.errorMessageForSizeFunction(), patternExpression.position())));
                            }
                        }
                    }
                }
                if (A1 instanceof PatternExpression) {
                    PatternExpression patternExpression = (PatternExpression)A1;
                    if (!PatternExpressionInNonExistenceCheck$.MODULE$.isExpectedTypeBoolean(this.baseState$1.semanticTable(), (Expression)patternExpression)) {
                        return (B1)(Function1 & Serializable)errors -> new Foldable.SkipChildren(errors.$colon$plus((Object)new SemanticError(PatternExpressionInNonExistenceCheck$.MODULE$.errorMessage(), patternExpression.position())));
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                Expression expression;
                Option option;
                Object object = x1;
                if (object instanceof Expression && !(option = Exists$.MODULE$.unapply(expression = (Expression)object)).isEmpty()) {
                    return true;
                }
                if (object instanceof FunctionInvocation) {
                    String string;
                    FunctionInvocation functionInvocation = (FunctionInvocation)object;
                    FunctionName functionName = functionInvocation.functionName();
                    IndexedSeq indexedSeq = functionInvocation.args();
                    if (functionName != null && "size".equals(string = functionName.name()) && indexedSeq instanceof Vector) {
                        Expression p;
                        Vector vector = (Vector)indexedSeq;
                        SeqOps seqOps = package$.MODULE$.Vector().unapplySeq((SeqOps)vector);
                        if (!SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (p = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof PatternExpression) {
                            PatternExpression patternExpression = (PatternExpression)p;
                            if (!PatternExpressionInNonExistenceCheck$.MODULE$.isExpectedTypeBoolean(this.baseState$1.semanticTable(), (Expression)patternExpression)) {
                                return true;
                            }
                        }
                    }
                }
                if (object instanceof PatternExpression) {
                    PatternExpression patternExpression = (PatternExpression)object;
                    if (!PatternExpressionInNonExistenceCheck$.MODULE$.isExpectedTypeBoolean(this.baseState$1.semanticTable(), (Expression)patternExpression)) {
                        return true;
                    }
                }
                return false;
            }
            {
                this.baseState$1 = baseState$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(scala.collection.immutable.Seq ), $anonfun$applyOrElse$2(org.neo4j.cypher.internal.expressions.PatternExpression scala.collection.immutable.Seq ), $anonfun$applyOrElse$3(org.neo4j.cypher.internal.expressions.PatternExpression scala.collection.immutable.Seq )}, serializedLambda);
            }
        });
    }

    public String errorMessage() {
        return errorMessage;
    }

    public String errorMessageForSizeFunction() {
        return errorMessageForSizeFunction;
    }

    private PatternExpressionInNonExistenceCheck$() {
    }
}

