/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.frontend.phases;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.neo4j.cypher.internal.ast.ProcedureResultItem;
import org.neo4j.cypher.internal.ast.Statement;
import org.neo4j.cypher.internal.ast.UnresolvedCall;
import org.neo4j.cypher.internal.frontend.phases.BaseContext;
import org.neo4j.cypher.internal.frontend.phases.BaseState;
import org.neo4j.cypher.internal.frontend.phases.CompilationPhaseTracer;
import org.neo4j.cypher.internal.frontend.phases.Phase;
import org.neo4j.cypher.internal.frontend.phases.ProcedureSignature;
import org.neo4j.cypher.internal.frontend.phases.QualifiedName;
import org.neo4j.cypher.internal.frontend.phases.ResolvedCall;
import org.neo4j.cypher.internal.frontend.phases.Transformer;
import org.neo4j.cypher.internal.frontend.phases.VisitorPhase;
import org.neo4j.cypher.internal.util.CancellationChecker;
import org.neo4j.cypher.internal.util.Foldable;
import org.neo4j.cypher.internal.util.InternalNotification;
import org.neo4j.cypher.internal.util.InternalNotificationLogger;
import org.neo4j.cypher.internal.util.RedundantOptionalProcedure;
import org.neo4j.cypher.internal.util.StepSequencer;
import org.neo4j.exceptions.InternalException;
import org.neo4j.notifications.ProcedureWarningNotification;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class ProcedureWarnings$
implements VisitorPhase<BaseContext, BaseState>,
Product,
Serializable {
    public static final ProcedureWarnings$ MODULE$ = new ProcedureWarnings$();

    static {
        Transformer.$init$(MODULE$);
        Phase.$init$(MODULE$);
        VisitorPhase.$init$(MODULE$);
        Product.$init$((Product)MODULE$);
    }

    public String productElementName(int n) {
        return Product.productElementName$((Product)this, (int)n);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    @Override
    public Object process(Object from, BaseContext context) {
        return VisitorPhase.process$(this, from, context);
    }

    @Override
    public Set<StepSequencer.Condition> postConditions() {
        return VisitorPhase.postConditions$(this);
    }

    @Override
    public Object transform(Object from, BaseContext context) {
        return Phase.transform$(this, from, context);
    }

    @Override
    public String name() {
        return Phase.name$(this);
    }

    @Override
    public void phaseValidation(Object from, Object to) {
        Phase.phaseValidation$(this, from, to);
    }

    @Override
    public <D extends BaseContext, TO2> Transformer<D, BaseState, TO2> andThen(Transformer<D, BaseState, TO2> other) {
        return Transformer.andThen$(this, other);
    }

    @Override
    public Set<StepSequencer.Condition> invalidatedConditions() {
        return Transformer.invalidatedConditions$(this);
    }

    @Override
    public final void checkConditions(Object state, Set<StepSequencer.Condition> conditions, CancellationChecker cancellationChecker) {
        Transformer.checkConditions$(this, state, conditions, cancellationChecker);
    }

    @Override
    public final void printDebugInfo(Object fromState, Object toState) {
        Transformer.printDebugInfo$(this, fromState, toState);
    }

    @Override
    public void visit(BaseState value, BaseContext context) {
        Set<InternalNotification> warnings = this.findWarnings(value.statement());
        InternalNotificationLogger internalNotificationLogger = context.notificationLogger();
        warnings.foreach((Function1 & Serializable)notification -> {
            internalNotificationLogger.log(notification);
            return BoxedUnit.UNIT;
        });
    }

    private Set<InternalNotification> findWarnings(Statement statement) {
        return (Set)statement.folder().treeFold((Object)Predef$.MODULE$.Set().empty(), (PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof ResolvedCall) {
                    ResolvedCall resolvedCall = (ResolvedCall)A1;
                    ProcedureSignature procedureSignature = resolvedCall.signature();
                    IndexedSeq<ProcedureResultItem> result = resolvedCall.callResults();
                    boolean optional = resolvedCall.optional();
                    if (procedureSignature != null) {
                        QualifiedName name = procedureSignature.name();
                        Option<String> maybeWarning = procedureSignature.warning();
                        return (B1)(Function1 & Serializable)seq -> {
                            Set set;
                            Option option = maybeWarning;
                            if (option instanceof Some) {
                                Some some = (Some)option;
                                String warning = (String)some.value();
                                set = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ProcedureWarningNotification[]{new ProcedureWarningNotification(resolvedCall.position(), name.toString(), warning)}));
                            } else {
                                set = Predef$.MODULE$.Set().empty();
                            }
                            return new Foldable.TraverseChildren((Object)seq.$plus$plus((IterableOnce)set).$plus$plus((IterableOnce)(optional && result.isEmpty() ? (IterableOnce)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new RedundantOptionalProcedure[]{new RedundantOptionalProcedure(resolvedCall.position(), name.toString())})) : Predef$.MODULE$.Set().empty())));
                        };
                    }
                }
                if (A1 instanceof UnresolvedCall) {
                    throw InternalException.internalError((String)ProcedureWarnings$.MODULE$.getClass().getSimpleName(), (String)"Expected procedures to have been resolved already");
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                ResolvedCall resolvedCall;
                ProcedureSignature procedureSignature;
                Object object = x1;
                if (object instanceof ResolvedCall && (procedureSignature = (resolvedCall = (ResolvedCall)object).signature()) != null) {
                    return true;
                }
                return object instanceof UnresolvedCall;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$14(scala.Option org.neo4j.cypher.internal.frontend.phases.ResolvedCall org.neo4j.cypher.internal.frontend.phases.QualifiedName boolean scala.collection.immutable.IndexedSeq scala.collection.immutable.Set )}, serializedLambda);
            }
        });
    }

    @Override
    public CompilationPhaseTracer.CompilationPhase phase() {
        return CompilationPhaseTracer.CompilationPhase.DEPRECATION_WARNINGS;
    }

    public String productPrefix() {
        return "ProcedureWarnings";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ProcedureWarnings$;
    }

    public int hashCode() {
        return -2016614358;
    }

    public String toString() {
        return "ProcedureWarnings";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ProcedureWarnings$.class);
    }

    private ProcedureWarnings$() {
    }
}

