/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.routing;

import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlException;
import org.neo4j.gqlstatus.GqlHelper;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.util.VisibleForTesting;

public class RoutingException
extends GqlException
implements Status.HasStatus {
    private final Status status;

    @VisibleForTesting
    public RoutingException(ErrorGqlStatusObject gqlStatusObject, Status status, String message) {
        super(gqlStatusObject, message);
        this.status = status;
    }

    public static RoutingException policyDefinitionNotFound(String policyName) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_08N15).withParam(GqlParams.StringParam.routingPolicy, policyName).build();
        return new RoutingException(gql, (Status)Status.Routing.RoutingFailed, String.format("Policy definition for '%s' could not be found.", policyName));
    }

    public static RoutingException serverPanic(String panicReason) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N32).build();
        return new RoutingException(gql, (Status)Status.Routing.DbmsInPanic, panicReason);
    }

    public static RoutingException invalidAddressKey() {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_52N16).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_52N10).build()).build();
        return new RoutingException(gql, (Status)Status.Procedure.ProcedureCallFailed, "An address key is included in the query string provided to the GetRoutingTableProcedure, but its value could not be parsed.");
    }

    public static RoutingException boltNotEnabled(String dbName) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N70).withParam(GqlParams.StringParam.db, dbName).build();
        return new RoutingException(gql, (Status)Status.Procedure.ProcedureCallFailed, "Cannot get routing table for " + dbName + " because Bolt is not enabled. Please update your configuration for '" + BoltConnector.enabled.name() + "'");
    }

    public static RoutingException routingTableIsEmpty(String dbName) {
        ErrorGqlStatusObject gql = GqlHelper.getGql08N09((String)dbName);
        return new RoutingException(gql, (Status)Status.General.DatabaseUnavailable, String.format("Routing table for database %s is empty", dbName));
    }

    public static RoutingException routingTableForUnavailableDb(String dbName) {
        ErrorGqlStatusObject gql = GqlHelper.getGql08N09((String)dbName);
        return new RoutingException(gql, (Status)Status.General.DatabaseUnavailable, String.format("Unable to get a routing table for database '%s' because this database is unavailable", dbName));
    }

    public static RoutingException routingTableForNonExistingDb(String dbName) {
        return new RoutingException(GqlHelper.getGql22000_22N51((String)dbName), (Status)Status.Database.DatabaseNotFound, "Unable to get a routing table for database '" + dbName + "' because this database does not exist");
    }

    public static RoutingException aliasChainsNotPermitted(String databaseName, String sourceAlias) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_08N14).withParam(GqlParams.StringParam.alias1, databaseName).withParam(GqlParams.StringParam.alias2, sourceAlias).build();
        return new RoutingException(gql, (Status)Status.Database.IllegalAliasChain, "Unable to provide a routing table for the database '" + databaseName + "' because the request came from another alias '" + sourceAlias + "' and alias chains are not permitted.");
    }

    public static RoutingException invalidRoutingRequest(String fieldName) {
        ErrorGqlStatusObject gqlCause = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_52N41).withParam(GqlParams.StringParam.field, fieldName).build();
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_52N16).withCause(gqlCause).build();
        return new RoutingException(gql, (Status)Status.Procedure.ProcedureCallFailed, gqlCause.getMessage());
    }

    public Status status() {
        return this.status;
    }
}

